/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.storage;

import com.google.common.eventbus.Subscribe;
import java.nio.file.Path;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationRemovedEvent;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.SonarProjectStorage;
import org.sonarsource.sonarlint.core.serverconnection.StorageFacade;
import org.sonarsource.sonarlint.core.serverconnection.StorageFacadeCache;

public class StorageService {
    private final Path globalStorageRoot;
    private final Path workDir;

    public StorageService(@Named(value="storageRoot") Path globalStorageRoot, @Named(value="workDir") Path workDir) {
        this.globalStorageRoot = globalStorageRoot;
        this.workDir = workDir;
    }

    public StorageFacade getStorageFacade() {
        return StorageFacadeCache.get().getOrCreate(this.globalStorageRoot, this.workDir);
    }

    public ConnectionStorage connection(String connectionId) {
        return this.getStorageFacade().connection(connectionId);
    }

    public SonarProjectStorage binding(Binding binding) {
        return this.getStorageFacade().connection(binding.getConnectionId()).project(binding.getSonarProjectKey());
    }

    @PreDestroy
    public void close() {
        StorageFacadeCache.get().close(this.globalStorageRoot);
    }

    @Subscribe
    public void handleEvent(ConnectionConfigurationRemovedEvent connectionConfigurationRemovedEvent) {
        String removedConnectionId = connectionConfigurationRemovedEvent.getRemovedConnectionId();
        ConnectionStorage connectionStorage = this.connection(removedConnectionId);
        connectionStorage.close();
        connectionStorage.delete();
    }
}

