/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.telemetry.TelemetryAnalyzerPerformance;
import org.sonarsource.sonarlint.core.telemetry.TelemetryHelpAndFeedbackCounter;
import org.sonarsource.sonarlint.core.telemetry.TelemetryNotificationsCounter;

public class TelemetryLocalStorage {
    @Deprecated
    private LocalDate installDate;
    private LocalDate lastUseDate;
    private LocalDateTime lastUploadDateTime;
    private OffsetDateTime installTime = OffsetDateTime.now();
    private long numUseDays;
    private boolean enabled = true;
    private final Map<String, TelemetryAnalyzerPerformance> analyzers = new LinkedHashMap<String, TelemetryAnalyzerPerformance>();
    private final Map<String, TelemetryNotificationsCounter> notificationsCountersByEventType = new LinkedHashMap<String, TelemetryNotificationsCounter>();
    private int showHotspotRequestsCount;
    private int showIssueRequestsCount;
    private int openHotspotInBrowserCount;
    private int taintVulnerabilitiesInvestigatedLocallyCount;
    private int taintVulnerabilitiesInvestigatedRemotelyCount;
    private int hotspotStatusChangedCount;
    private Set<String> issueStatusChangedRuleKeys = new HashSet<String>();
    private final Set<String> raisedIssuesRules = new HashSet<String>();
    private final Set<String> quickFixesApplied = new HashSet<String>();
    private final Map<String, TelemetryHelpAndFeedbackCounter> helpAndFeedbackLinkClickedCount = new LinkedHashMap<String, TelemetryHelpAndFeedbackCounter>();
    private boolean isFocusOnNewCode;
    private int codeFocusChangedCount;

    TelemetryLocalStorage() {
    }

    public Collection<String> getRaisedIssuesRules() {
        return this.raisedIssuesRules;
    }

    public void addReportedRules(Set<String> reportedRuleKeys) {
        this.raisedIssuesRules.addAll(reportedRuleKeys);
    }

    public Collection<String> getQuickFixesApplied() {
        return this.quickFixesApplied;
    }

    public void addQuickFixAppliedForRule(String ruleKey) {
        this.quickFixesApplied.add(ruleKey);
    }

    @Deprecated
    void setInstallDate(LocalDate date) {
        this.installDate = date;
    }

    @Deprecated
    LocalDate installDate() {
        return this.installDate;
    }

    OffsetDateTime installTime() {
        return this.installTime;
    }

    public void setInstallTime(OffsetDateTime installTime) {
        this.installTime = installTime;
    }

    void setLastUseDate(@Nullable LocalDate date) {
        this.lastUseDate = date;
    }

    @CheckForNull
    LocalDate lastUseDate() {
        return this.lastUseDate;
    }

    public Map<String, TelemetryAnalyzerPerformance> analyzers() {
        return this.analyzers;
    }

    public Map<String, TelemetryNotificationsCounter> notifications() {
        return this.notificationsCountersByEventType;
    }

    public Map<String, TelemetryHelpAndFeedbackCounter> getHelpAndFeedbackLinkClickedCounter() {
        return this.helpAndFeedbackLinkClickedCount;
    }

    public boolean isFocusOnNewCode() {
        return this.isFocusOnNewCode;
    }

    public int getCodeFocusChangedCount() {
        return this.codeFocusChangedCount;
    }

    void setLastUploadTime() {
        this.setLastUploadTime(LocalDateTime.now());
    }

    void setLastUploadTime(@Nullable LocalDateTime dateTime) {
        this.lastUploadDateTime = dateTime;
    }

    @CheckForNull
    LocalDateTime lastUploadTime() {
        return this.lastUploadDateTime;
    }

    void setNumUseDays(long numUseDays) {
        this.numUseDays = numUseDays;
    }

    void clearAfterPing() {
        this.analyzers.clear();
        this.notificationsCountersByEventType.clear();
        this.showHotspotRequestsCount = 0;
        this.showIssueRequestsCount = 0;
        this.openHotspotInBrowserCount = 0;
        this.taintVulnerabilitiesInvestigatedLocallyCount = 0;
        this.taintVulnerabilitiesInvestigatedRemotelyCount = 0;
        this.hotspotStatusChangedCount = 0;
        this.issueStatusChangedRuleKeys.clear();
        this.raisedIssuesRules.clear();
        this.quickFixesApplied.clear();
        this.helpAndFeedbackLinkClickedCount.clear();
        this.codeFocusChangedCount = 0;
    }

    long numUseDays() {
        return this.numUseDays;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean enabled() {
        return this.enabled;
    }

    void setUsedAnalysis() {
        this.markSonarLintAsUsedToday();
    }

    private void markSonarLintAsUsedToday() {
        LocalDate now = LocalDate.now();
        if (this.lastUseDate == null || !this.lastUseDate.equals(now)) {
            ++this.numUseDays;
        }
        this.lastUseDate = now;
    }

    void setUsedAnalysis(String language, int analysisTimeMs) {
        this.markSonarLintAsUsedToday();
        TelemetryAnalyzerPerformance analyzer = this.analyzers.computeIfAbsent(language, x -> new TelemetryAnalyzerPerformance());
        analyzer.registerAnalysis(analysisTimeMs);
    }

    static boolean isOlder(@Nullable LocalDate first, @Nullable LocalDate second) {
        return first == null || second != null && first.isBefore(second);
    }

    static boolean isOlder(@Nullable LocalDateTime first, @Nullable LocalDateTime second) {
        return first == null || second != null && first.isBefore(second);
    }

    static TelemetryLocalStorage validateAndMigrate(TelemetryLocalStorage data) {
        LocalDate lastUseDate;
        LocalDate today = LocalDate.now();
        if (data.installDate() != null && (data.installTime() == null || data.installTime().toLocalDate().isAfter(data.installDate()))) {
            data.setInstallTime(data.installDate.atTime(OffsetTime.now()));
        }
        if (data.installTime() == null || data.installTime().isAfter(OffsetDateTime.now())) {
            data.setInstallTime(OffsetDateTime.now());
        }
        if ((lastUseDate = data.lastUseDate()) == null) {
            data.setNumUseDays(0L);
            data.analyzers.clear();
            return data;
        }
        if (lastUseDate.isBefore(data.installTime().toLocalDate())) {
            data.setLastUseDate(data.installTime().toLocalDate());
        } else if (lastUseDate.isAfter(today)) {
            data.setLastUseDate(today);
        }
        long maxUseDays = data.installTime().toLocalDate().until(data.lastUseDate(), ChronoUnit.DAYS) + 1L;
        if (data.numUseDays() > maxUseDays) {
            data.setNumUseDays(maxUseDays);
            data.setLastUseDate(data.lastUseDate());
        }
        return data;
    }

    public void incrementDevNotificationsCount(String eventType) {
        this.notificationsCountersByEventType.computeIfAbsent(eventType, k -> new TelemetryNotificationsCounter()).incrementDevNotificationsCount();
    }

    public void incrementDevNotificationsClicked(String eventType) {
        this.markSonarLintAsUsedToday();
        this.notificationsCountersByEventType.computeIfAbsent(eventType, k -> new TelemetryNotificationsCounter()).incrementDevNotificationsClicked();
    }

    public void incrementShowHotspotRequestCount() {
        this.markSonarLintAsUsedToday();
        ++this.showHotspotRequestsCount;
    }

    public int showHotspotRequestsCount() {
        return this.showHotspotRequestsCount;
    }

    public void incrementShowIssueRequestCount() {
        this.markSonarLintAsUsedToday();
        ++this.showIssueRequestsCount;
    }

    public int getShowIssueRequestsCount() {
        return this.showIssueRequestsCount;
    }

    public void incrementOpenHotspotInBrowserCount() {
        this.markSonarLintAsUsedToday();
        ++this.openHotspotInBrowserCount;
    }

    public int openHotspotInBrowserCount() {
        return this.openHotspotInBrowserCount;
    }

    public void incrementTaintVulnerabilitiesInvestigatedLocallyCount() {
        this.markSonarLintAsUsedToday();
        ++this.taintVulnerabilitiesInvestigatedLocallyCount;
    }

    public int taintVulnerabilitiesInvestigatedLocallyCount() {
        return this.taintVulnerabilitiesInvestigatedLocallyCount;
    }

    public void incrementTaintVulnerabilitiesInvestigatedRemotelyCount() {
        this.markSonarLintAsUsedToday();
        ++this.taintVulnerabilitiesInvestigatedRemotelyCount;
    }

    public int taintVulnerabilitiesInvestigatedRemotelyCount() {
        return this.taintVulnerabilitiesInvestigatedRemotelyCount;
    }

    public void helpAndFeedbackLinkClicked(String itemId) {
        this.helpAndFeedbackLinkClickedCount.computeIfAbsent(itemId, k -> new TelemetryHelpAndFeedbackCounter()).incrementHelpAndFeedbackLinkClickedCount();
    }

    public void incrementHotspotStatusChangedCount() {
        this.markSonarLintAsUsedToday();
        ++this.hotspotStatusChangedCount;
    }

    public int hotspotStatusChangedCount() {
        return this.hotspotStatusChangedCount;
    }

    public void addIssueStatusChanged(String ruleKey) {
        this.markSonarLintAsUsedToday();
        this.issueStatusChangedRuleKeys.add(ruleKey);
    }

    public Set<String> issueStatusChangedRuleKeys() {
        return this.issueStatusChangedRuleKeys;
    }

    public void setInitialNewCodeFocus(boolean focusOnNewCode) {
        this.markSonarLintAsUsedToday();
        this.isFocusOnNewCode = focusOnNewCode;
    }

    public void incrementNewCodeFocusChange() {
        this.markSonarLintAsUsedToday();
        this.isFocusOnNewCode = !this.isFocusOnNewCode;
        ++this.codeFocusChangedCount;
    }
}

