/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import com.google.common.util.concurrent.MoreExecutors;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.ResolutionStatus;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.ClientTrackedFindingDto;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.IssueTrackingService;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.LineWithHashDto;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.LocalOnlyIssueDto;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.ServerMatchedIssueDto;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.TextRangeWithHashDto;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.TrackWithServerIssuesParams;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.TrackWithServerIssuesResponse;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.commons.LineWithHash;
import org.sonarsource.sonarlint.core.commons.LocalOnlyIssue;
import org.sonarsource.sonarlint.core.commons.LocalOnlyIssueResolution;
import org.sonarsource.sonarlint.core.commons.NewCodeDefinition;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.issuetracking.Trackable;
import org.sonarsource.sonarlint.core.issuetracking.Tracker;
import org.sonarsource.sonarlint.core.issuetracking.Tracking;
import org.sonarsource.sonarlint.core.local.only.LocalOnlyIssueStorageService;
import org.sonarsource.sonarlint.core.newcode.NewCodeServiceImpl;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.vcs.ActiveSonarProjectBranchRepository;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerIssue;
import org.sonarsource.sonarlint.core.storage.StorageService;
import org.sonarsource.sonarlint.core.sync.SynchronizationServiceImpl;
import org.sonarsource.sonarlint.core.tracking.ClientTrackedFindingTrackable;
import org.sonarsource.sonarlint.core.tracking.LocalOnlyIssueRepository;
import org.sonarsource.sonarlint.core.tracking.LocalOnlyIssueTrackable;
import org.sonarsource.sonarlint.core.tracking.ServerIssueTrackable;
import org.sonarsource.sonarlint.core.utils.FutureUtils;

@Named
@Singleton
public class IssueTrackingServiceImpl
implements IssueTrackingService {
    private static final int FETCH_ALL_ISSUES_THRESHOLD = 10;
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ConfigurationRepository configurationRepository;
    private final StorageService storageService;
    private final ActiveSonarProjectBranchRepository activeSonarProjectBranchRepository;
    private final SynchronizationServiceImpl synchronizationService;
    private final LocalOnlyIssueRepository localOnlyIssueRepository;
    private final LocalOnlyIssueStorageService localOnlyIssueStorageService;
    private final NewCodeServiceImpl newCodeService;
    private final ExecutorService executorService;

    public IssueTrackingServiceImpl(ConfigurationRepository configurationRepository, StorageService storageService, ActiveSonarProjectBranchRepository activeSonarProjectBranchRepository, SynchronizationServiceImpl synchronizationService, LocalOnlyIssueStorageService localOnlyIssueStorageService, LocalOnlyIssueRepository localOnlyIssueRepository, NewCodeServiceImpl newCodeService) {
        this.configurationRepository = configurationRepository;
        this.storageService = storageService;
        this.activeSonarProjectBranchRepository = activeSonarProjectBranchRepository;
        this.synchronizationService = synchronizationService;
        this.localOnlyIssueRepository = localOnlyIssueRepository;
        this.localOnlyIssueStorageService = localOnlyIssueStorageService;
        this.newCodeService = newCodeService;
        this.executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "sonarlint-server-tracking-issue-updater"));
    }

    @Override
    public CompletableFuture<TrackWithServerIssuesResponse> trackWithServerIssues(TrackWithServerIssuesParams params) {
        return CompletableFutures.computeAsync(cancelChecker -> {
            String configurationScopeId = params.getConfigurationScopeId();
            Optional<Binding> effectiveBindingOpt = this.configurationRepository.getEffectiveBinding(configurationScopeId);
            Optional<String> activeBranchOpt = this.activeSonarProjectBranchRepository.getActiveSonarProjectBranch(configurationScopeId);
            if (effectiveBindingOpt.isEmpty() || activeBranchOpt.isEmpty()) {
                return new TrackWithServerIssuesResponse(params.getClientTrackedIssuesByServerRelativePath().entrySet().stream().map(e -> Map.entry((String)e.getKey(), ((List)e.getValue()).stream().map(issue -> Either.forRight(new LocalOnlyIssueDto(UUID.randomUUID(), null))).collect(Collectors.toList()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
            Binding binding = effectiveBindingOpt.get();
            String activeBranch = activeBranchOpt.get();
            if (params.shouldFetchIssuesFromServer()) {
                this.refreshServerIssues((CancelChecker)cancelChecker, binding, activeBranch, params);
            }
            Map<String, List<ClientTrackedFindingDto>> clientTrackedIssuesByServerRelativePath = params.getClientTrackedIssuesByServerRelativePath();
            NewCodeDefinition newCodeDefinition = this.newCodeService.getFullNewCodeDefinition(configurationScopeId).orElse(NewCodeDefinition.withAlwaysNew());
            return new TrackWithServerIssuesResponse(clientTrackedIssuesByServerRelativePath.entrySet().stream().map(e -> {
                String serverRelativePath = (String)e.getKey();
                List<ServerIssue> serverIssues = this.storageService.binding(binding).findings().load(activeBranch, serverRelativePath);
                List<LocalOnlyIssue> localOnlyIssues = this.localOnlyIssueStorageService.get().loadForFile(configurationScopeId, serverRelativePath);
                Collection<ClientTrackedFindingTrackable> clientIssueTrackables = IssueTrackingServiceImpl.toTrackables((List)e.getValue());
                List matches = this.matchIssues(serverRelativePath, serverIssues, localOnlyIssues, clientIssueTrackables).stream().map(result -> {
                    if (result.isLeft()) {
                        ServerIssue serverIssue = (ServerIssue)result.getLeft();
                        long creationDate = serverIssue.getCreationDate().toEpochMilli();
                        boolean isOnNewCode = newCodeDefinition.isOnNewCode(creationDate);
                        return Either.forLeft(new ServerMatchedIssueDto(UUID.randomUUID(), serverIssue.getKey(), creationDate, serverIssue.isResolved(), serverIssue.getUserSeverity(), serverIssue.getType(), isOnNewCode));
                    }
                    LocalOnlyIssue localOnlyIssue = (LocalOnlyIssue)result.getRight();
                    LocalOnlyIssueResolution resolution = localOnlyIssue.getResolution();
                    return Either.forRight(new LocalOnlyIssueDto(localOnlyIssue.getId(), resolution == null ? null : ResolutionStatus.valueOf(resolution.getStatus().name())));
                }).collect(Collectors.toList());
                return Map.entry(serverRelativePath, matches);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        });
    }

    private void refreshServerIssues(CancelChecker cancelChecker, Binding binding, String activeBranch, TrackWithServerIssuesParams params) {
        Set<String> serverFileRelativePaths = params.getClientTrackedIssuesByServerRelativePath().keySet();
        boolean downloadAllIssuesAtOnce = serverFileRelativePaths.size() > 10;
        LinkedList fetchTasks = new LinkedList();
        if (downloadAllIssuesAtOnce) {
            fetchTasks.add(this.executorService.submit(() -> this.synchronizationService.fetchProjectIssues(binding, activeBranch)));
        } else {
            fetchTasks.addAll(serverFileRelativePaths.stream().map(serverFileRelativePath -> this.executorService.submit(() -> this.synchronizationService.fetchFileIssues(binding, (String)serverFileRelativePath, activeBranch))).collect(Collectors.toList()));
        }
        Future<?> waitForTasksTask = this.executorService.submit(() -> FutureUtils.waitForTasks(cancelChecker, fetchTasks, "Wait for server issues", Duration.ofSeconds(20L)));
        FutureUtils.waitForTask(cancelChecker, waitForTasksTask, "Wait for server issues (global timeout)", Duration.ofSeconds(60L));
    }

    private List<Either<ServerIssue, LocalOnlyIssue>> matchIssues(String serverRelativePath, List<ServerIssue> serverIssues, List<LocalOnlyIssue> localOnlyIssues, Collection<ClientTrackedFindingTrackable> clientTrackedIssueTrackables) {
        Tracker tracker = new Tracker();
        Tracking trackingResult = tracker.track(() -> new ArrayList(clientTrackedIssueTrackables), () -> IssueTrackingServiceImpl.mergeTrackables(IssueTrackingServiceImpl.toServerIssueTrackables(serverIssues), IssueTrackingServiceImpl.toLocalOnlyIssueTrackables(localOnlyIssues)));
        List<Either<ServerIssue, LocalOnlyIssue>> matches = clientTrackedIssueTrackables.stream().map(clientTrackedFindingTrackable -> {
            Object match = trackingResult.getMatch(clientTrackedFindingTrackable);
            if (match != null) {
                if (match.getServerIssueKey() != null) {
                    return Either.forLeft(((ServerIssueTrackable)match).getServerIssue());
                }
                return Either.forRight(((LocalOnlyIssueTrackable)match).getLocalOnlyIssue());
            }
            ClientTrackedFindingDto clientTrackedIssue = clientTrackedFindingTrackable.getClientTrackedIssue();
            return Either.forRight(new LocalOnlyIssue(UUID.randomUUID(), serverRelativePath, IssueTrackingServiceImpl.adapt(clientTrackedIssue.getTextRangeWithHash()), IssueTrackingServiceImpl.adapt(clientTrackedIssue.getLineWithHash()), clientTrackedIssue.getRuleKey(), clientTrackedIssue.getMessage(), null));
        }).collect(Collectors.toList());
        List<LocalOnlyIssue> localOnlyIssuesMatched = matches.stream().filter(Either::isRight).map(Either::getRight).collect(Collectors.toList());
        this.localOnlyIssueRepository.save(serverRelativePath, localOnlyIssuesMatched);
        return matches;
    }

    @CheckForNull
    private static TextRangeWithHash adapt(@Nullable TextRangeWithHashDto textRange) {
        return textRange == null ? null : new TextRangeWithHash(textRange.getStartLine(), textRange.getStartLineOffset(), textRange.getEndLine(), textRange.getEndLineOffset(), textRange.getHash());
    }

    @CheckForNull
    private static LineWithHash adapt(@Nullable LineWithHashDto line) {
        return line == null ? null : new LineWithHash(line.getNumber(), line.getHash());
    }

    private static Collection<ClientTrackedFindingTrackable> toTrackables(List<ClientTrackedFindingDto> clientTrackedIssue) {
        return clientTrackedIssue.stream().map(ClientTrackedFindingTrackable::new).collect(Collectors.toList());
    }

    private static Collection<Trackable> mergeTrackables(Collection<Trackable> serverTrackables, Collection<Trackable> localOnlyTrackables) {
        return Stream.of(serverTrackables, localOnlyTrackables).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Collection<Trackable> toServerIssueTrackables(List<ServerIssue> serverIssues) {
        return serverIssues.stream().map(ServerIssueTrackable::new).collect(Collectors.toList());
    }

    private static Collection<Trackable> toLocalOnlyIssueTrackables(List<LocalOnlyIssue> localOnlyIssues) {
        return localOnlyIssues.stream().map(LocalOnlyIssueTrackable::new).collect(Collectors.toList());
    }

    @PreDestroy
    public void shutdown() {
        if (!MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorService, (long)1L, (TimeUnit)TimeUnit.SECONDS)) {
            LOG.warn("Unable to stop issue updater executor service in a timely manner");
        }
    }
}

