/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.commons.LocalOnlyIssue;

@Named
@Singleton
public class LocalOnlyIssueRepository {
    private final Map<String, List<LocalOnlyIssue>> localOnlyIssuesByRelativePath = new ConcurrentHashMap<String, List<LocalOnlyIssue>>();

    public void save(String serverRelativePath, List<LocalOnlyIssue> localOnlyIssues) {
        this.localOnlyIssuesByRelativePath.put(serverRelativePath, localOnlyIssues);
    }

    public Optional<LocalOnlyIssue> findByKey(UUID localOnlyIssueKey) {
        return this.localOnlyIssuesByRelativePath.values().stream().flatMap(Collection::stream).filter(issue -> issue.getId().equals(localOnlyIssueKey)).findFirst();
    }
}

