/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonarsource.sonarlint.core.commons.objectstore.HashingPathMapper;
import org.sonarsource.sonarlint.core.commons.objectstore.Reader;
import org.sonarsource.sonarlint.core.commons.objectstore.Writer;
import org.sonarsource.sonarlint.core.issuetracking.Trackable;
import org.sonarsource.sonarlint.core.issuetracking.TrackableIssueStore;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.tracking.IndexedObjectStore;
import org.sonarsource.sonarlint.core.tracking.PathStoreKeyValidator;
import org.sonarsource.sonarlint.core.tracking.ProtobufIssueTrackable;
import org.sonarsource.sonarlint.core.tracking.StringStoreIndex;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.FileUtils;

public class ProtobufIssueStore<T>
implements TrackableIssueStore<T> {
    private Path basePath;
    private IndexedObjectStore<String, Sonarlint.Issues> store;

    public ProtobufIssueStore(Path storeBasePath, Path projectBasePath) {
        this.basePath = storeBasePath;
        try {
            FileUtils.forceMkdir(this.basePath.toFile());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create issue store directory", e);
        }
        StringStoreIndex index = new StringStoreIndex(storeBasePath);
        HashingPathMapper mapper = new HashingPathMapper(storeBasePath, 2);
        PathStoreKeyValidator validator = new PathStoreKeyValidator(projectBasePath);
        Reader reader = is -> {
            try {
                return Sonarlint.Issues.parseFrom(is);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read issues", e);
            }
        };
        Writer writer = (os, issues) -> {
            try {
                issues.writeTo(os);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to save issues", e);
            }
        };
        this.store = new IndexedObjectStore(index, mapper, reader, writer, validator);
        this.store.deleteInvalid();
    }

    @Override
    public boolean contains(String key) {
        return this.store.contains(key);
    }

    @Override
    public void save(String key, Collection<Trackable<T>> issues) throws IOException {
        this.store.write(key, this.transform(issues));
    }

    @Override
    @CheckForNull
    public Collection<Trackable<T>> read(String key) throws IOException {
        Optional<Sonarlint.Issues> issues = this.store.read(key);
        return issues.map(this::transform).orElse(null);
    }

    public void clean() {
        this.store.deleteInvalid();
    }

    @Override
    public void clear() {
        try {
            FileUtils.deleteDirectory(this.basePath.toFile());
            FileUtils.forceMkdir(this.basePath.toFile());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to clear issue store", e);
        }
    }

    private Collection<Trackable<T>> transform(Sonarlint.Issues protoIssues) {
        return protoIssues.getIssueList().stream().map(this::transform).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Sonarlint.Issues transform(Collection<Trackable<T>> localIssues) {
        Sonarlint.Issues.Builder builder = Sonarlint.Issues.newBuilder();
        localIssues.stream().map(this::transform).filter(Objects::nonNull).forEach(builder::addIssue);
        return builder.build();
    }

    private Trackable<T> transform(Sonarlint.Issues.Issue issue) {
        return new ProtobufIssueTrackable(issue);
    }

    @CheckForNull
    private Sonarlint.Issues.Issue transform(Trackable<T> localIssue) {
        Sonarlint.Issues.Issue.Builder builder = Sonarlint.Issues.Issue.newBuilder().setRuleKey(localIssue.getRuleKey()).setMessage(localIssue.getMessage()).setResolved(localIssue.isResolved());
        if (localIssue.getCreationDate() != null) {
            builder.setCreationDate(localIssue.getCreationDate());
        }
        if (localIssue.getLineHash() != null) {
            builder.setLineHash(localIssue.getLineHash());
        }
        if (localIssue.getServerIssueKey() != null) {
            builder.setServerIssueKey(localIssue.getServerIssueKey());
        }
        if (localIssue.getLine() != null) {
            builder.setLine(localIssue.getLine());
        }
        return builder.build();
    }
}

