/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.websocket;

import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.client.smartnotification.ShowSmartNotificationParams;
import org.sonarsource.sonarlint.core.commons.BoundScope;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.serverconnection.events.ServerEventHandler;
import org.sonarsource.sonarlint.core.telemetry.TelemetryServiceImpl;
import org.sonarsource.sonarlint.core.websocket.events.SmartNotificationEvent;

public class ShowSmartNotificationOnSmartNotificationEvent
implements ServerEventHandler<SmartNotificationEvent> {
    private final SonarLintClient client;
    private final ConfigurationRepository configurationRepository;
    private final TelemetryServiceImpl telemetryService;

    public ShowSmartNotificationOnSmartNotificationEvent(SonarLintClient client, ConfigurationRepository configurationRepository, TelemetryServiceImpl telemetryService) {
        this.client = client;
        this.configurationRepository = configurationRepository;
        this.telemetryService = telemetryService;
    }

    @Override
    public void handle(SmartNotificationEvent event) {
        String projectKey = event.getProject();
        this.configurationRepository.getBoundScopesByProject(projectKey).stream().collect(Collectors.groupingBy(BoundScope::getConnectionId)).forEach((connectionId, scope) -> this.client.showSmartNotification(new ShowSmartNotificationParams(event.getMessage(), event.getLink(), scope.stream().map(BoundScope::getId).collect(Collectors.toSet()), event.getCategory(), (String)connectionId)));
        this.telemetryService.smartNotificationsReceived(event.getCategory());
    }
}

