/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.shaded.org.springframework.context.event;

import java.util.Map;
import org.sonarsource.sonarlint.shaded.org.springframework.aop.support.AopUtils;
import org.sonarsource.sonarlint.shaded.org.springframework.context.ApplicationEvent;
import org.sonarsource.sonarlint.shaded.org.springframework.context.ApplicationListener;
import org.sonarsource.sonarlint.shaded.org.springframework.context.event.GenericApplicationListener;
import org.sonarsource.sonarlint.shaded.org.springframework.context.event.SmartApplicationListener;
import org.sonarsource.sonarlint.shaded.org.springframework.core.Ordered;
import org.sonarsource.sonarlint.shaded.org.springframework.core.ResolvableType;
import org.sonarsource.sonarlint.shaded.org.springframework.lang.Nullable;
import org.sonarsource.sonarlint.shaded.org.springframework.util.Assert;
import org.sonarsource.sonarlint.shaded.org.springframework.util.ConcurrentReferenceHashMap;

public class GenericApplicationListenerAdapter
implements GenericApplicationListener {
    private static final Map<Class<?>, ResolvableType> eventTypeCache = new ConcurrentReferenceHashMap();
    private final ApplicationListener<ApplicationEvent> delegate;
    @Nullable
    private final ResolvableType declaredEventType;

    public GenericApplicationListenerAdapter(ApplicationListener<?> delegate) {
        Assert.notNull(delegate, "Delegate listener must not be null");
        this.delegate = delegate;
        this.declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(this.delegate);
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        this.delegate.onApplicationEvent(event);
    }

    @Override
    public boolean supportsEventType(ResolvableType eventType) {
        if (this.delegate instanceof GenericApplicationListener) {
            return ((GenericApplicationListener)this.delegate).supportsEventType(eventType);
        }
        if (this.delegate instanceof SmartApplicationListener) {
            Class<?> eventClass = eventType.resolve();
            return eventClass != null && ((SmartApplicationListener)this.delegate).supportsEventType(eventClass);
        }
        return this.declaredEventType == null || this.declaredEventType.isAssignableFrom(eventType);
    }

    @Override
    public boolean supportsSourceType(@Nullable Class<?> sourceType) {
        return !(this.delegate instanceof SmartApplicationListener) || ((SmartApplicationListener)this.delegate).supportsSourceType(sourceType);
    }

    @Override
    public int getOrder() {
        return this.delegate instanceof Ordered ? ((Ordered)((Object)this.delegate)).getOrder() : Integer.MAX_VALUE;
    }

    @Override
    public String getListenerId() {
        return this.delegate instanceof SmartApplicationListener ? ((SmartApplicationListener)this.delegate).getListenerId() : "";
    }

    @Nullable
    private static ResolvableType resolveDeclaredEventType(ApplicationListener<ApplicationEvent> listener) {
        Class<?> targetClass;
        ResolvableType declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(listener.getClass());
        if ((declaredEventType == null || declaredEventType.isAssignableFrom(ApplicationEvent.class)) && (targetClass = AopUtils.getTargetClass(listener)) != listener.getClass()) {
            declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(targetClass);
        }
        return declaredEventType;
    }

    @Nullable
    static ResolvableType resolveDeclaredEventType(Class<?> listenerType) {
        ResolvableType eventType = eventTypeCache.get(listenerType);
        if (eventType == null) {
            eventType = ResolvableType.forClass(listenerType).as(ApplicationListener.class).getGeneric(new int[0]);
            eventTypeCache.put(listenerType, eventType);
        }
        return eventType != ResolvableType.NONE ? eventType : null;
    }
}

