/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.authorization;

import com.teamscale.core.permissions.ServicePermissions;
import java.util.function.Function;

public enum EComplexPermission {
    MAY_ACCESS_ADMIN_PERSPECTIVE(ServicePermissions::mayAccessAdminPerspective, "User must have permissions to configure users or groups or have permissions to edit global notification settings or to create backups."),
    MAY_ACCESS_PROJECTS_PERSPECTIVE(ServicePermissions::mayAccessProjectsPerspective, "User must have permission to either configure projects, analysis profiles, metric threshold configurations or permission to edit external findings or metrics schemas."),
    MAY_CONFIGURE_ANALYSIS_PROFILES(ServicePermissions::mayConfigureAnalysisProfiles, "User must either have the permission to create analysis profiles, or the permission to view any existing analysis profile."),
    MAY_ACCESS_AUDIT_PERSPECTIVE(ServicePermissions::mayAccessAuditPerspective, "User must have audit support included in the license."),
    MAY_RETRIEVE_GLOBAL_ANALYSIS_PROGRESS(ServicePermissions::mayRetrieveGlobalAnalysisProgress, "User must either have the permission to view system status or the permission to access administrative services"),
    MAY_CONFIGURE_PROJECTS(ServicePermissions::mayConfigureProjects, "User must either have the global permission to create projects, or the permission to view any existing project."),
    MAY_CONFIGURE_EXTERNAL_CREDENTIALS(ServicePermissions::mayConfigureExternalCredentials, "User must have the permission to configure external accounts."),
    MAY_VIEW_AUTHENTICATION_SERVERS(ServicePermissions::mayViewAuthenticationServers, "User must have the permission to edit or create groups or users to view authentication servers.");

    private final Function<ServicePermissions, Boolean> permissionCheck;
    private final String description;

    private EComplexPermission(Function<ServicePermissions, Boolean> permissionCheck, String description) {
        this.permissionCheck = permissionCheck;
        this.description = description;
    }

    public boolean hasPermission(ServicePermissions servicePermissions) {
        return this.permissionCheck.apply(servicePermissions);
    }

    public String getDescription() {
        return this.description;
    }
}

