/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.security;

import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class SecuritySettingsUtils {
    public static final String ALLOWED_SCRIPT_HASH_HEADER = "X-ALLOWED-CSP-SCRIPT-HASH";

    public static void allowScript(Response.ResponseBuilder builder, String allowedScriptCode) throws NoSuchAlgorithmException {
        builder.header(ALLOWED_SCRIPT_HASH_HEADER, (Object)SecuritySettingsUtils.generateCSPHash(allowedScriptCode));
    }

    public static void allowUnsafeEval(Response.ResponseBuilder builder) {
        builder.header(ALLOWED_SCRIPT_HASH_HEADER, (Object)"'unsafe-eval'");
    }

    private static String generateCSPHash(String str) throws NoSuchAlgorithmException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        MessageDigest digestInstance = MessageDigest.getInstance("SHA-256");
        byte[] digestBytes = digestInstance.digest(bytes);
        String rawHash = Base64.getMimeEncoder().encodeToString(digestBytes);
        return String.format("'sha256-%s'", rawHash);
    }

    private SecuritySettingsUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

