/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

import java.util.Arrays;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.StringHelper;
import us.hebi.matlab.mat.util.Preconditions;

public abstract class AbstractArray
implements Array {
    protected final int[] dims;
    private final int[] dimStrides;

    @Override
    public int[] getDimensions() {
        return this.dims;
    }

    @Override
    public int getNumDimensions() {
        return this.getDimensions().length;
    }

    @Override
    public int getNumRows() {
        return this.getDimensions()[0];
    }

    @Override
    public int getNumCols() {
        return this.getDimensions()[1];
    }

    @Override
    public int getNumElements() {
        return AbstractArray.getNumElements(this.getDimensions());
    }

    public static int getNumElements(int[] dimensions) {
        int count = dimensions[0];
        for (int i = 1; i < dimensions.length; ++i) {
            count *= dimensions[i];
        }
        return count;
    }

    public static long getNumElementsLong(int[] dimensions) {
        long count = dimensions[0];
        for (int i = 1; i < dimensions.length; ++i) {
            count *= (long)dimensions[i];
        }
        return count;
    }

    protected static int[] calculateColMajorStrides(int[] dimensions) {
        int[] dimStrides = new int[dimensions.length];
        dimStrides[0] = 1;
        for (int i = 0; i < dimStrides.length - 1; ++i) {
            dimStrides[i + 1] = dimensions[i] * dimStrides[i];
        }
        return dimStrides;
    }

    protected int getColumnMajorIndex(int row, int col) {
        this.checkNumDimensions(2);
        int ix0 = this.checkIndexBounds(row, 0);
        int ix1 = this.checkIndexBounds(col, 1);
        return ix0 * this.dimStrides[0] + ix1 * this.dimStrides[1];
    }

    protected int getColumnMajorIndex(int[] indices) {
        this.checkNumDimensions(indices.length);
        int index = 0;
        for (int i = 0; i < indices.length; ++i) {
            index += this.dimStrides[i] * this.checkIndexBounds(indices[i], i);
        }
        return index;
    }

    protected void checkNumDimensions(int numDim) {
        if (numDim != this.dimStrides.length) {
            throw new IllegalArgumentException("Expected " + this.dimStrides.length + " dimensions. Found: " + numDim);
        }
    }

    protected int checkIndexBounds(int index, int dim) {
        if (index >= 0 && index < this.dims[dim]) {
            return index;
        }
        String msg = String.format("Index exceeds matrix dimension %d. %d/%d", dim, index, this.dims[dim] - 1);
        throw new IllegalArgumentException(msg);
    }

    protected AbstractArray(int[] dims) {
        this.dims = Preconditions.checkNotNull(dims);
        Preconditions.checkArgument(dims.length >= 2, "Every array must have at least two dimensions");
        this.dimStrides = AbstractArray.calculateColMajorStrides(dims);
    }

    public String toString() {
        return StringHelper.toString(this);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.dims);
        result = 31 * result + this.subHashCode();
        return result;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass().equals(this.getClass())) {
            AbstractArray otherArray = (AbstractArray)other;
            return Arrays.equals(otherArray.dims, this.dims) && this.subEqualsGuaranteedSameClass(other);
        }
        return false;
    }

    protected abstract int subHashCode();

    protected abstract boolean subEqualsGuaranteedSameClass(Object var1);
}

