/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import us.hebi.matlab.mat.types.AbstractStructBase;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Struct;

public abstract class AbstractStruct
extends AbstractStructBase {
    private final HashMap<String, Integer> indexMap = new HashMap();
    private final List<String> fields = new ArrayList<String>();
    private final List<Array[]> values = new ArrayList<Array[]>();

    protected AbstractStruct(int[] dims) {
        super(dims);
    }

    @Override
    public List<String> getFieldNames() {
        return this.fields;
    }

    @Override
    public Array[] remove(String field) {
        Integer fieldIndex = this.indexMap.remove(AbstractStruct.checkNonEmpty(field));
        if (fieldIndex == null) {
            throw new IllegalArgumentException("A field named '" + field + "' doesn't exist.");
        }
        this.fields.remove(fieldIndex);
        Array[] removed = this.values.remove(fieldIndex);
        this.rebuildIndexMap();
        return removed;
    }

    private void rebuildIndexMap() {
        this.indexMap.clear();
        int i = 0;
        for (String field : this.fields) {
            this.indexMap.put(field, i++);
        }
    }

    @Override
    public <T extends Array> T get(String field, int index) {
        Integer fieldIndex = this.indexMap.get(AbstractStruct.checkNonEmpty(field));
        if (fieldIndex == null) {
            throw new IllegalArgumentException("Reference to non-existent field '" + field + "'");
        }
        return (T)this.values.get(fieldIndex)[index];
    }

    @Override
    public Struct set(String field, int index, Array value) {
        this.getOrInitValues((String)field)[index] = value;
        return this;
    }

    protected abstract Array getEmptyValue();

    protected Array[] getOrInitValues(String field) {
        Integer fieldIndex = this.indexMap.get(AbstractStruct.checkNonEmpty(field));
        if (fieldIndex != null) {
            return this.values.get(fieldIndex);
        }
        Object[] value = new Array[this.getNumElements()];
        Arrays.fill(value, this.getEmptyValue());
        this.indexMap.put(field, this.values.size());
        this.fields.add(field);
        this.values.add((Array[])value);
        return value;
    }

    protected static String checkNonEmpty(String field) {
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException("Field name can't be empty.");
        }
        return field;
    }

    @Override
    public void close() throws IOException {
        for (Array[] value : this.values) {
            for (Array array : value) {
                array.close();
            }
        }
        this.indexMap.clear();
        this.fields.clear();
        this.values.clear();
    }

    @Override
    protected int subHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.indexMap.hashCode();
        result = 31 * result + this.fields.hashCode();
        for (Object[] objectArray : this.values) {
            result = 31 * result + Arrays.hashCode(objectArray);
        }
        return result;
    }

    @Override
    protected boolean subEqualsGuaranteedSameClass(Object otherGuaranteedSameClass) {
        AbstractStruct other = (AbstractStruct)otherGuaranteedSameClass;
        if (other.indexMap.equals(this.indexMap) && other.fields.equals(this.fields) && other.values.size() == this.values.size()) {
            for (int i = 0; i < this.values.size(); ++i) {
                if (Arrays.equals(other.values.get(i), this.values.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

