/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.util;

import java.io.IOException;

public class IndentingAppendable
implements Appendable {
    private String indentString = "  ";
    private int numIndents = 0;
    private int maxLineWidth = 160;
    private int currentLine = 0;
    private String overflowString = "...";
    private final Appendable appendable;

    public IndentingAppendable(Appendable appendable) {
        this.appendable = appendable;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public void setMaxLineWidth(int maxLineWidth) {
        this.maxLineWidth = maxLineWidth;
    }

    public String getOverflowString() {
        return this.overflowString;
    }

    public void setOverflowString(String overflowString) {
        this.overflowString = overflowString;
    }

    public IndentingAppendable indent() {
        ++this.numIndents;
        return this;
    }

    public IndentingAppendable unindent() {
        --this.numIndents;
        return this;
    }

    public IndentingAppendable append(Object object) {
        return this.append(String.valueOf(object));
    }

    @Override
    public IndentingAppendable append(CharSequence csq) {
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public IndentingAppendable append(CharSequence csq, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public IndentingAppendable append(char c) {
        try {
            return this.append0(c);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private IndentingAppendable append0(char c) throws IOException {
        if (c == '\n') {
            this.appendable.append(c);
            this.currentLine = 0;
            for (int i = 0; i < this.numIndents; ++i) {
                this.append(this.indentString);
            }
            return this;
        }
        if (this.currentLine >= this.maxLineWidth) {
            return this;
        }
        if (this.currentLine > this.maxLineWidth - this.overflowString.length()) {
            this.currentLine += this.overflowString.length();
            this.appendable.append(this.overflowString);
            return this;
        }
        ++this.currentLine;
        this.appendable.append(c);
        return this;
    }
}

