/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser.compact;

import com.teamscale.reportparser.model.TeamscaleCompactCoverageReport;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.ProbeCoverageInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class TeamscaleCompactCoverageReportHandler {
    private final CoverageInfoRetriever coverageInfoRetriever;

    public TeamscaleCompactCoverageReportHandler(CoverageInfoRetriever coverageInfoRetriever) {
        CCSMAssert.isNotNull((Object)coverageInfoRetriever);
        this.coverageInfoRetriever = coverageInfoRetriever;
    }

    public void handleReport(TeamscaleCompactCoverageReport teamscaleCompactCoverageReport) {
        for (TeamscaleCompactCoverageReport.CompactCoverageFileInfo fileInfo : teamscaleCompactCoverageReport.fileCoverageInfos()) {
            String filePath = fileInfo.getFilePath();
            this.addLineCoverage(fileInfo, filePath);
            this.addProbeCoverage(fileInfo, filePath);
        }
    }

    private void addLineCoverage(TeamscaleCompactCoverageReport.CompactCoverageFileInfo fileInfo, String filePath) {
        LineCoverageInfo lineInfo = this.coverageInfoRetriever.getOrCreateLineCoverageInfo(filePath);
        lineInfo.addLineCoverage(fileInfo.getFullyCoveredLines(), ELineCoverage.FULLY_COVERED);
        if (fileInfo.getPartiallyCoveredLines() != null) {
            lineInfo.addLineCoverage(fileInfo.getPartiallyCoveredLines(), ELineCoverage.PARTIALLY_COVERED);
        }
        if (fileInfo.getUncoveredLines() != null) {
            lineInfo.addLineCoverage(fileInfo.getUncoveredLines(), ELineCoverage.NOT_COVERED);
        }
    }

    private void addProbeCoverage(TeamscaleCompactCoverageReport.CompactCoverageFileInfo fileInfo, String qualifiedSourceName) {
        if (fileInfo.getCoverageProbes() == null) {
            return;
        }
        ProbeCoverageInfo probeCoverageInfo = this.coverageInfoRetriever.getOrCreateProbeCoverageInfo(qualifiedSourceName);
        probeCoverageInfo.setProbes(fileInfo.getCoverageProbes());
    }
}

