/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser.gcov;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public class GcovReportHandler {
    private static final Pattern BRANCH_TAKEN_PATTERN = Pattern.compile("taken (\\d+)");
    private final CoverageInfoRetriever lineCoverageInfoRetriever;
    private LineCoverageInfo currentCoverageInfo = null;
    private static final String SOURCE_PREFIX = "Source:";

    public GcovReportHandler(CoverageInfoRetriever lineCoverageInfoRetriever) {
        CCSMAssert.isNotNull((Object)lineCoverageInfoRetriever);
        this.lineCoverageInfoRetriever = lineCoverageInfoRetriever;
    }

    public void handleReport(String report) throws ConQATException {
        List lines = StringUtils.splitLinesAsList((String)report);
        for (int i = 0; i < lines.size(); ++i) {
            int lineNumber;
            String[] parts = ((String)lines.get(i)).split(":", 3);
            if (parts.length != 3) continue;
            try {
                lineNumber = Integer.parseInt(parts[1].trim());
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (lineNumber == 0) {
                if (!parts[2].startsWith(SOURCE_PREFIX)) continue;
                this.currentCoverageInfo = this.lineCoverageInfoRetriever.getOrCreateLineCoverageInfo(StringUtils.stripPrefix((String)parts[2], (String)SOURCE_PREFIX));
                continue;
            }
            if (this.currentCoverageInfo == null) {
                throw new ConQATException("Missing 'Source:' at start of file!");
            }
            this.updateCoverageInfo(parts[0].trim(), lineNumber, lines, i);
        }
    }

    private void updateCoverageInfo(String prefix, int lineNumber, List<String> reportLines, int reportLineNumber) {
        int branchTaken = 0;
        int branchNotTaken = 0;
        for (int i = reportLineNumber + 1; i < reportLines.size(); ++i) {
            String line = reportLines.get(i);
            if (line.startsWith("call")) continue;
            if (!line.startsWith("branch")) break;
            Matcher matcher = BRANCH_TAKEN_PATTERN.matcher(line);
            if (matcher.find() && Long.parseLong(matcher.group(1)) > 0L) {
                ++branchTaken;
                continue;
            }
            ++branchNotTaken;
        }
        if (!prefix.equals("-")) {
            if (prefix.startsWith("#")) {
                this.currentCoverageInfo.addLineCoverage(lineNumber, ELineCoverage.NOT_COVERED);
            } else if (branchTaken > 0 && branchNotTaken > 0) {
                this.currentCoverageInfo.addLineCoverage(lineNumber, ELineCoverage.PARTIALLY_COVERED);
            } else {
                this.currentCoverageInfo.addLineCoverage(lineNumber, ELineCoverage.FULLY_COVERED);
            }
        }
    }
}

