/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client;

import com.burgstaller.okhttp.AuthenticationCacheInterceptor;
import com.burgstaller.okhttp.CachingAuthenticatorDecorator;
import com.burgstaller.okhttp.digest.Credentials;
import com.burgstaller.okhttp.digest.DigestAuthenticator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.rest.client.HttpRedirectInterceptor;
import com.teamscale.core.rest.client.HttpRequestRateLimiter;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.core.rest.client.authentication.ERestClientAuthenticationMode;
import com.teamscale.core.rest.client.authentication.ICustomAuthenticationInterceptor;
import com.teamscale.core.rest.client.authentication.ntlm.NtlmAuthenticator;
import com.teamscale.core.rest.client.calladapter.SynchronousCallAdapterFactory;
import com.teamscale.core.rest.client.converter.ConverterFactory;
import com.teamscale.core.rest.client.converter.IBodyConverterProfilingMonitor;
import com.teamscale.core.rest.client.cookie.Cookie;
import com.teamscale.core.rest.client.cookie.CookieUtils;
import com.teamscale.core.rest.client.logging.LoggingInterceptor;
import com.teamscale.core.rest.client.metrics.PrometheusMetricsInterceptor;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.BiConsumerWithException;
import org.conqat.lib.commons.net.TrustAllCertificatesManager;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.system.SystemUtils;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

public class Retrofit {
    public static final String USER_AGENT = "Teamscale/" + String.valueOf(ETeamscaleVersion.CURRENT_VERSION) + " (" + SystemUtils.getHostName() + ")";
    private static final int DEFAULT_READ_TIMEOUT_IN_SECONDS = 180;
    @VisibleForTesting
    static final String BASIC_AUTHENTICATION_PREFIX = "Basic";
    public static final String BEARER_AUTHENTICATION_PREFIX = "Bearer";
    private static final String USER_AGENT_HEADER_NAME = "User-Agent";
    private static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final Logger LOGGER = LogManager.getLogger();
    private static SSLContext sslContext = null;
    private static final ConcurrentHashMap<String, IRetrofitApi> API_MOCKS_BY_CLASS_NAME = new ConcurrentHashMap();
    private final retrofit2.Retrofit retrofit;

    private Retrofit(retrofit2.Retrofit retrofit) {
        this.retrofit = retrofit;
    }

    public static void overwriteSslContext(SSLContext customSslContext) {
        sslContext = customSslContext;
    }

    public <T extends IRetrofitApi> T create(Class<T> apiClass) {
        if (API_MOCKS_BY_CLASS_NAME.containsKey(apiClass.getName())) {
            return (T)((IRetrofitApi)apiClass.cast(API_MOCKS_BY_CLASS_NAME.get(apiClass.getName())));
        }
        return (T)((IRetrofitApi)this.retrofit.create(apiClass));
    }

    @TestOnly
    public static <T extends IRetrofitApi> void registerApiForTesting(Class<T> apiClass, T mock) {
        API_MOCKS_BY_CLASS_NAME.put(apiClass.getName(), mock);
    }

    @TestOnly
    public static <T extends IRetrofitApi> void deregisterApiForTesting(Class<T> apiClass) {
        API_MOCKS_BY_CLASS_NAME.remove(apiClass.getName());
    }

    public static <T> Optional<T> executeServiceCall(Call<T> serviceCall) throws ServiceCallException {
        Response<T> response = Retrofit.executeRaw(serviceCall);
        return Optional.ofNullable(response.body());
    }

    public static int executeServiceCallAndGetStatus(Call<?> serviceCall) throws ServiceCallException {
        Response<?> response = Retrofit.executeRaw(serviceCall);
        return response.code();
    }

    public static <T> Pair<Headers, Optional<T>> executeServiceCallAndGetHeaders(Call<T> serviceCall) throws ServiceCallException {
        Response<T> response = Retrofit.executeRaw(serviceCall);
        return Pair.createPair((Object)response.headers(), Optional.ofNullable(response.body()));
    }

    private static <T> Response<T> executeRaw(Call<T> serviceCall) throws ServiceCallException {
        Response response;
        try {
            response = serviceCall.execute();
        }
        catch (IOException e) {
            throw new ServiceCallException("Failed to execute request " + String.valueOf(serviceCall.request().url()) + ". Error message:\n" + e.getMessage(), (Throwable)e);
        }
        if (!response.isSuccessful()) {
            throw new ServiceCallException(serviceCall.request().url().uri(), response.message(), response.code(), Retrofit.readErrorBody(response));
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> String readErrorBody(Response<T> response) {
        try (ResponseBody errorBody = response.errorBody();){
            if (errorBody == null) {
                String string = "";
                return string;
            }
            String contentType = response.headers().get(CONTENT_TYPE_HEADER_NAME);
            if (contentType != null && contentType.contains("text/html")) {
                LOGGER.warn("Got HTML as error body:");
                LOGGER.warn(errorBody.string());
                String string = "Check the service log for details.";
                return string;
            }
            String string = errorBody.string();
            return string;
        }
        catch (IOException e) {
            return "(failed to read error body from response)";
        }
    }

    public static Builder builder(String baseUrl) {
        return new Builder(baseUrl);
    }

    public static class Builder {
        private static final ConcurrentHashMap<String, HttpRequestRateLimiter> RATE_LIMITERS_BY_BASE_URL = new ConcurrentHashMap();
        private long readTimeoutInSeconds = 180L;
        private final String baseUrl;
        private @Nullable String username;
        private @Nullable String password = null;
        private @Nullable Charset basicAuthEncodingCharset;
        private @Nullable Logger interactionLogger;
        private final List<Interceptor> interceptors = new ArrayList<Interceptor>(Collections.singleton(Builder.createUserAgentInterceptor()));
        private final List<String> cookies = new ArrayList<String>();
        private boolean preserveCookies;
        private @Nullable ERestClientAuthenticationMode authenticationMode = null;
        private @Nullable ObjectMapper objectMapper = JsonUtils.getObjectMapper();
        private final List<Converter.Factory> converterFactories = new ArrayList<Converter.Factory>();
        private IBodyConverterProfilingMonitor deserializationProfilingMonitor = IBodyConverterProfilingMonitor.NO_OP_PROFILER;
        private final List<BiConsumerWithException<ResponseBody, Type, IOException>> responseValidators = new ArrayList<BiConsumerWithException<ResponseBody, Type, IOException>>();
        private boolean disableRedirectsForPost = false;
        private @Nullable HttpRequestRetryPolicy retryPolicy = HttpRequestRetryPolicy.SYSTEM_DEFAULT;
        private boolean wasBuiltAlready = false;
        private boolean retryOnConnectionFailure = false;

        private Builder(String baseUrl) {
            Preconditions.checkArgument((!StringUtils.isEmpty((String)baseUrl) ? 1 : 0) != 0, (Object)"Base URL should not be empty.");
            this.baseUrl = StringUtils.ensureEndsWith((String)baseUrl, (String)"/");
        }

        public Retrofit build() {
            Preconditions.checkState((!this.wasBuiltAlready ? 1 : 0) != 0, (Object)"Cannot build the same builder twice");
            this.wasBuiltAlready = true;
            Retrofit.Builder builder = new Retrofit.Builder().client(this.buildClient()).baseUrl(this.baseUrl);
            builder.addCallAdapterFactory((CallAdapter.Factory)new SynchronousCallAdapterFactory());
            if (this.objectMapper != null) {
                builder.addConverterFactory((Converter.Factory)ConverterFactory.create(this.objectMapper, this.responseValidators, this.deserializationProfilingMonitor));
            } else {
                Preconditions.checkState((boolean)this.responseValidators.isEmpty(), (Object)"Setting custom response validators without an object mapper is not supported.");
            }
            for (Converter.Factory converterFactory : this.converterFactories) {
                builder.addConverterFactory(converterFactory);
            }
            return new Retrofit(builder.build());
        }

        public <T extends IRetrofitApi> T create(Class<T> apiClass) {
            return this.build().create(apiClass);
        }

        @Deprecated
        public OkHttpClient buildOkHttpClient() {
            return this.buildClient();
        }

        public Builder withInteractionLogger(Logger interactionLogger) {
            this.interactionLogger = interactionLogger;
            return this;
        }

        public Builder withNoAuthentication() {
            this.authenticationMode = ERestClientAuthenticationMode.NONE;
            this.username = null;
            this.password = null;
            return this;
        }

        public Builder withBasicNTLMAuthentication(String username, String password, @Nullable Charset basicAuthEncodingCharset) {
            this.authenticationMode = ERestClientAuthenticationMode.BASIC_NTLM;
            this.username = username;
            this.password = password;
            this.basicAuthEncodingCharset = basicAuthEncodingCharset;
            return this;
        }

        public Builder withBasicNTLMAuthentication(String username, String password) {
            return this.withBasicNTLMAuthentication(username, password, null);
        }

        public Builder withBasicAuthentication(String username, String password, @Nullable Charset encodingCharset) {
            this.authenticationMode = ERestClientAuthenticationMode.BASIC;
            this.username = username;
            this.password = password;
            this.basicAuthEncodingCharset = encodingCharset;
            return this;
        }

        public Builder withBearerAuthentication(String token) {
            this.authenticationMode = ERestClientAuthenticationMode.BEARER;
            this.username = null;
            this.password = token;
            return this;
        }

        public Builder withJWTAuthentication(String token) {
            this.authenticationMode = ERestClientAuthenticationMode.JWT;
            this.username = null;
            this.password = token;
            return this;
        }

        public Builder withDigestAuthentication(String username, String password) {
            this.authenticationMode = ERestClientAuthenticationMode.DIGEST;
            this.username = username;
            this.password = password;
            return this;
        }

        public Builder withAuthenticationMode(ERestClientAuthenticationMode authenticationMode, String username, String passwordOrToken) {
            return switch (authenticationMode) {
                default -> throw new MatchException(null, null);
                case ERestClientAuthenticationMode.NONE -> this.withNoAuthentication();
                case ERestClientAuthenticationMode.BASIC -> this.withBasicAuthentication(username, passwordOrToken, this.basicAuthEncodingCharset);
                case ERestClientAuthenticationMode.BEARER -> this.withBearerAuthentication(passwordOrToken);
                case ERestClientAuthenticationMode.DIGEST -> this.withDigestAuthentication(username, passwordOrToken);
                case ERestClientAuthenticationMode.BASIC_NTLM -> this.withBasicNTLMAuthentication(username, passwordOrToken, this.basicAuthEncodingCharset);
                case ERestClientAuthenticationMode.JWT -> this.withJWTAuthentication(this.password);
            };
        }

        public Builder withCustomAuthenticationInterceptor(ICustomAuthenticationInterceptor interceptor) {
            this.authenticationMode = ERestClientAuthenticationMode.NONE;
            this.username = null;
            this.password = null;
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder withInterceptors(Interceptor ... interceptors) {
            Collections.addAll(this.interceptors, interceptors);
            return this;
        }

        public Builder withCookies(List<String> cookies) {
            this.cookies.addAll(cookies);
            return this;
        }

        public Builder withPreservedCookies() {
            this.preserveCookies = true;
            return this;
        }

        public Builder withDisabledRedirectsForPost() {
            this.disableRedirectsForPost = true;
            return this;
        }

        public Builder withReadTimeout(long readTimeoutInSeconds) {
            this.readTimeoutInSeconds = readTimeoutInSeconds;
            return this;
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder withRetryPolicy(@Nullable HttpRequestRetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        @SafeVarargs
        public final Builder withResponseValidators(BiConsumerWithException<ResponseBody, Type, IOException> ... validators) {
            this.responseValidators.addAll(List.of(validators));
            return this;
        }

        public final Builder withConverterFactory(Converter.Factory converterFactory) {
            this.converterFactories.add(converterFactory);
            return this;
        }

        @TestOnly
        public final Builder withRetryOnConnectionFailure() {
            this.retryOnConnectionFailure = true;
            return this;
        }

        public Builder withDeserializationProfilingMonitor(IBodyConverterProfilingMonitor profilingMonitor) {
            this.deserializationProfilingMonitor = profilingMonitor;
            return this;
        }

        public Builder withCustomRateLimiter(@NonNull HttpRequestRateLimiter rateLimiter) {
            RATE_LIMITERS_BY_BASE_URL.put(this.baseUrl, rateLimiter);
            return this;
        }

        private OkHttpClient buildClient() {
            Preconditions.checkState((this.authenticationMode != null ? 1 : 0) != 0, (Object)"Must set an authentication mode. If no authentication should be used, please set this explicitly.");
            CookieJar cookieJar = this.createCookieJar();
            OkHttpClient.Builder clientBuilder = Builder.getHttpClientBuilder(cookieJar);
            clientBuilder.readTimeout(this.readTimeoutInSeconds, TimeUnit.SECONDS);
            Builder.addAuthenticationInterceptor(this.username, this.password, this.basicAuthEncodingCharset, this.authenticationMode, clientBuilder);
            this.interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)clientBuilder).addInterceptor(arg_0));
            clientBuilder.setRetryOnConnectionFailure$okhttp(this.retryOnConnectionFailure);
            clientBuilder.setFollowRedirects$okhttp(false);
            if (this.retryPolicy != null) {
                clientBuilder.addInterceptor(this.retryPolicy.createInterceptor());
            }
            clientBuilder.addInterceptor((Interceptor)new HttpRedirectInterceptor(this.disableRedirectsForPost));
            clientBuilder.addInterceptor((Interceptor)Builder.createRateLimitingInterceptor(this.baseUrl));
            clientBuilder.addInterceptor((Interceptor)new PrometheusMetricsInterceptor());
            if (this.interactionLogger != null) {
                clientBuilder.addInterceptor((Interceptor)new LoggingInterceptor(HttpLoggingInterceptor.Level.BODY, Level.DEBUG, this.interactionLogger));
            }
            return clientBuilder.build();
        }

        private static HttpRequestRateLimiter createRateLimitingInterceptor(String baseUrl) {
            return RATE_LIMITERS_BY_BASE_URL.computeIfAbsent(baseUrl, unused -> new HttpRequestRateLimiter());
        }

        private @Nullable CookieJar createCookieJar() {
            if (this.cookies.isEmpty() && !this.preserveCookies) {
                return null;
            }
            return Builder.createCookieJar(CollectionUtils.map(CookieUtils.parseCookies(URI.create(this.baseUrl), this.cookies), Builder::asOkHttpCookie), this.preserveCookies);
        }

        private static CookieJar createCookieJar(final List<okhttp3.Cookie> cookies, final boolean preserveCookies) {
            return new CookieJar(){
                private final Set<okhttp3.Cookie> storedCookies = new HashSet<okhttp3.Cookie>();

                public void saveFromResponse(@NonNull HttpUrl url, @NonNull List<okhttp3.Cookie> serverCookies) {
                    if (preserveCookies) {
                        this.storedCookies.addAll(serverCookies);
                    }
                }

                public @NonNull List<okhttp3.Cookie> loadForRequest(@NonNull HttpUrl url) {
                    ArrayList<okhttp3.Cookie> cookiesForRequest = new ArrayList<okhttp3.Cookie>(cookies);
                    cookiesForRequest.addAll(this.storedCookies);
                    return CollectionUtils.filter(cookiesForRequest, cookie -> cookie.matches(url) && cookie.expiresAt() > System.currentTimeMillis());
                }
            };
        }

        private static okhttp3.Cookie asOkHttpCookie(Cookie cookie) {
            return new Cookie.Builder().domain(cookie.getDomain()).name(cookie.getName()).value(cookie.getValue()).path(cookie.getPath()).build();
        }

        private static Interceptor createUserAgentInterceptor() {
            return chain -> {
                Request newRequest = chain.request().newBuilder().addHeader(Retrofit.USER_AGENT_HEADER_NAME, USER_AGENT).build();
                return chain.proceed(newRequest);
            };
        }

        private static void addAuthenticationInterceptor(String username, String password, @Nullable Charset basicAuthEncodingCharset, ERestClientAuthenticationMode authenticationMode, OkHttpClient.Builder clientBuilder) {
            switch (authenticationMode) {
                case NONE: {
                    break;
                }
                case BASIC: {
                    clientBuilder.addInterceptor(Builder.createAuthenticatingBasicInterceptor(username, password, basicAuthEncodingCharset));
                    break;
                }
                case BEARER: {
                    clientBuilder.addInterceptor(Builder.createAuthenticatingBearerInterceptor(password));
                    break;
                }
                case JWT: {
                    clientBuilder.addInterceptor(Builder.createAuthenticatingJWTTokenInterceptor(password));
                    break;
                }
                case DIGEST: {
                    ConcurrentHashMap authCache = new ConcurrentHashMap();
                    Credentials credentials = new Credentials(username, password);
                    DigestAuthenticator authenticator = new DigestAuthenticator(credentials);
                    clientBuilder.authenticator((Authenticator)new CachingAuthenticatorDecorator((Authenticator)authenticator, authCache)).addInterceptor((Interceptor)new AuthenticationCacheInterceptor(authCache));
                    break;
                }
                case BASIC_NTLM: {
                    Builder.addBasicNtlmAuthenticationInterceptors(username, password, basicAuthEncodingCharset, clientBuilder);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported authentication mode " + String.valueOf((Object)authenticationMode));
                }
            }
        }

        private static void addBasicNtlmAuthenticationInterceptors(String username, String password, @Nullable Charset basicAuthEncodingCharset, OkHttpClient.Builder clientBuilder) {
            clientBuilder.addInterceptor(Builder.createAuthenticatingBasicInterceptor(username, password, basicAuthEncodingCharset));
            clientBuilder.authenticator((Authenticator)new NtlmAuthenticator(username, password));
            clientBuilder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        }

        private static Interceptor createAuthenticatingBasicInterceptor(String username, String password, @Nullable Charset encodingCharset) {
            return chain -> {
                String credentials = username + ":" + password;
                byte[] credentialsBytes = credentials.getBytes(Optional.ofNullable(encodingCharset).orElse(StandardCharsets.ISO_8859_1));
                String base64AuthInfo = Base64.getEncoder().encodeToString(credentialsBytes);
                Request newRequest = chain.request().newBuilder().addHeader("Authorization", "Basic " + base64AuthInfo).build();
                return chain.proceed(newRequest);
            };
        }

        private static Interceptor createAuthenticatingBearerInterceptor(String accessToken) {
            return chain -> {
                Request newRequest = chain.request().newBuilder().addHeader("Authorization", "Bearer " + accessToken).build();
                return chain.proceed(newRequest);
            };
        }

        private static Interceptor createAuthenticatingJWTTokenInterceptor(String accessToken) {
            return chain -> {
                Request newRequest = chain.request().newBuilder().addHeader("Authorization", "JWT " + accessToken).build();
                return chain.proceed(newRequest);
            };
        }

        private static OkHttpClient.Builder getHttpClientBuilder(@Nullable CookieJar cookieJar) {
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            if (sslContext != null) {
                clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)new TrustAllCertificatesManager());
            }
            if (cookieJar != null) {
                clientBuilder.cookieJar(cookieJar);
            }
            return clientBuilder;
        }
    }
}

