/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.SSLException;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;

public class TeamscaleHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int RETRY_COUNT = 3;

    public TeamscaleHttpRequestRetryHandler() {
        super(3, false, (Collection)CollectionUtils.asUnmodifiable(Arrays.asList(ConnectException.class, UnknownHostException.class, SSLException.class)));
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        boolean shouldRetry = super.retryRequest(exception, executionCount, context);
        LOGGER.warn("Checking whether to retry request\nRetry: " + shouldRetry + "\nExecution count: " + executionCount + "\nContext: " + String.valueOf(context), (Throwable)exception);
        return shouldRetry;
    }
}

