/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap;

import java.util.regex.Pattern;

public enum EClassIncludeType {
    CCAU("/sap/bc/adt/oo/classes/%s/includes/testclasses"),
    CCDEF("/sap/bc/adt/oo/classes/%s/includes/definitions"),
    CCIMP("/sap/bc/adt/oo/classes/%s/includes/implementations"),
    CCMAC("/sap/bc/adt/oo/classes/%s/includes/macros"),
    CI("/sap/bc/adt/oo/classes/%s/source/main"),
    CMxxx("^\\S{30}CM\\S{3}$", "/sap/bc/adt/oo/classes/%s/source/main"),
    CO("/sap/bc/adt/oo/classes/%s/source/main"),
    CP("/sap/bc/adt/oo/classes/%s/source/main"),
    CU("/sap/bc/adt/oo/classes/%s/source/main"),
    CL("/sap/bc/adt/oo/classes/%s/includes/localtypes");

    private final Pattern pattern;
    private final String adtPathFormat;

    private EClassIncludeType(String adtPathFormat) {
        this.pattern = Pattern.compile("^\\S{30}" + this.name() + "$");
        this.adtPathFormat = adtPathFormat;
    }

    private EClassIncludeType(String pattern, String adtPathFormat) {
        this.pattern = Pattern.compile(pattern);
        this.adtPathFormat = adtPathFormat;
    }

    public boolean matches(String includeName) {
        return this.pattern.matcher(includeName).matches();
    }

    public String getAdtUrlPathFormat() {
        return this.adtPathFormat;
    }
}

