/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.AbapConditionalStatementsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Check(id="cqse-abap-constant-boolean-comparison", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AbapConstantBooleanComparisonCheck
extends AbapConditionalStatementsCheckBase {
    private static final Set<String> FORBIDDEN_COMPARISON_CHARACTERS = Set.of("' '", "'X'");
    private static final String SPACE = "space";

    @Override
    boolean checkCondition(List<IToken> conditionTokens) {
        if (conditionTokens.size() == 1) {
            return AbapConstantBooleanComparisonCheck.isForbiddenToken(conditionTokens.get(0));
        }
        for (int i = 1; i < conditionTokens.size() - 1; ++i) {
            IToken token = conditionTokens.get(i);
            if (token.getType() != ETokenType.EQ && token.getType() != ETokenType.NEQ) continue;
            IToken left = conditionTokens.get(i - 1);
            IToken right = conditionTokens.get(i + 1);
            if (!AbapConstantBooleanComparisonCheck.isForbiddenToken(left) && !AbapConstantBooleanComparisonCheck.isForbiddenToken(right)) continue;
            return true;
        }
        return false;
    }

    private static boolean isForbiddenToken(IToken token) {
        return token.getType() == ETokenType.CHARACTER_LITERAL && FORBIDDEN_COMPARISON_CHARACTERS.contains(token.getText()) || token.getType() == ETokenType.IDENTIFIER && Objects.equals(token.getText(), SPACE);
    }

    @Override
    void buildFinding(List<IToken> tokens) {
        this.buildFinding("Boolean comparison should use `abap_bool` constants", this.buildLocation().forTokens(tokens)).createAndStore();
    }
}

