/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Check(id="cqse-arithmetic-operation-on-text-literal", languages={ELanguage.ABAP})
public class ArithmeticOperationOnTextLiteralCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Arithmetic operation on text literal";
    private static final Pattern NUMERIC_STRING_LITERAL_PATTERN = Pattern.compile("['`]([-+]?(\\d+|\\d*\\.\\d+)|(\\d+|\\d*\\.\\d+)[-+])['`]");
    private static final Pattern TEXT_SYMBOL_PATTERN = Pattern.compile("TEXT-\\w\\w\\w", 2);
    private static final Pattern JOINED_TEXT_SYMBOL_END_PATTERN = Pattern.compile("'\\(\\w\\w\\w\\)");
    private static final ITokenMatcher ARITHMETIC_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PLUS, ETokenType.MINUS, ETokenType.MULT, ETokenType.DIV, ETokenType.INTEGER_DIV, ETokenType.MOD, ETokenType.EXPONENTIATION});
    private static final EnumSet<ETokenType> CHARACTER_LITERAL_TYPES = EnumSet.of(ETokenType.CHARACTER_LITERAL, ETokenType.STRING_LITERAL);
    @CheckOption(name="Arithmetic operation on text literal - ignore numeric literals", description="Ignores character literals which only contain numeric values.")
    private boolean ignoreNumberLiteals = true;
    private List<IToken> tokens;
    private final Set<IToken> tokensWithFinding = new HashSet<IToken>();

    public void execute() throws CheckException {
        this.tokens = this.context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED);
        this.tokens = this.tokens.stream().filter(t -> !TokenUtils.isCommentToken((IToken)t)).collect(Collectors.toList());
        List arithmeticOperatorTokens = TokenStreamUtils.findAll(this.tokens, (ITokenMatcher)ARITHMETIC_OPERATORS);
        Iterator iterator = arithmeticOperatorTokens.iterator();
        while (iterator.hasNext()) {
            int operatorIndex = (Integer)iterator.next();
            if (this.isNewLineSlash(operatorIndex) || this.isAsteriskInDereferenceOperator(operatorIndex)) continue;
            int tokenBeforeIndex = operatorIndex - 1;
            if (this.isEndOfJoinedTextLiteral(tokenBeforeIndex)) {
                tokenBeforeIndex -= 3;
            }
            this.createFindingIfTextLiteral(tokenBeforeIndex);
            this.createFindingIfTextLiteral(operatorIndex + 1);
        }
    }

    private boolean isEndOfJoinedTextLiteral(int tokenIndex) throws CheckException {
        if (tokenIndex < 3 || this.tokens.get(tokenIndex).getType() != ETokenType.RPAREN || !CHARACTER_LITERAL_TYPES.contains(this.tokens.get(tokenIndex - 3).getType())) {
            return false;
        }
        String joinedEndText = this.context.getTextContent(ECodeViewOption.ETextViewOption.FILTERED_CONTENT).substring(this.tokens.get(tokenIndex - 2).getOffset() - 1, this.tokens.get(tokenIndex).getEndOffset() + 1);
        return JOINED_TEXT_SYMBOL_END_PATTERN.matcher(joinedEndText).matches();
    }

    private void createFindingIfTextLiteral(int tokenIndex) throws CheckException {
        if (tokenIndex < 0 || tokenIndex >= this.tokens.size()) {
            return;
        }
        IToken token = this.tokens.get(tokenIndex);
        if (this.tokensWithFinding.contains(token)) {
            return;
        }
        String tokenText = token.getText();
        if (!CHARACTER_LITERAL_TYPES.contains(token.getType()) && !TEXT_SYMBOL_PATTERN.matcher(tokenText).matches()) {
            return;
        }
        if (this.ignoreNumberLiteals && NUMERIC_STRING_LITERAL_PATTERN.matcher(tokenText).matches()) {
            return;
        }
        this.buildFinding("Arithmetic operation on text literal `` " + token.getText() + " ``", this.buildLocation().forToken(token)).createAndStore();
        this.tokensWithFinding.add(token);
    }

    private boolean isNewLineSlash(int operatorTokenIndex) {
        if (operatorTokenIndex < 1 || this.tokens.get(operatorTokenIndex).getType() != ETokenType.DIV) {
            return false;
        }
        int keywordTokenIndex = operatorTokenIndex - 1;
        if (keywordTokenIndex >= 1 && (this.tokens.get(keywordTokenIndex).getType() == ETokenType.AT || this.tokens.get(keywordTokenIndex).getType() == ETokenType.COLON)) {
            --keywordTokenIndex;
        }
        return EnumSet.of(ETokenType.WRITE, ETokenType.ULINE).contains(this.tokens.get(keywordTokenIndex).getType());
    }

    private boolean isAsteriskInDereferenceOperator(int operatorTokenIndex) {
        if (operatorTokenIndex < 1 || this.tokens.get(operatorTokenIndex).getType() != ETokenType.MULT) {
            return false;
        }
        return this.tokens.get(operatorTokenIndex - 1).getType() == ETokenType.ARROW;
    }
}

