/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.base.CommentCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageProperties;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-incorrect-abap-doc-check", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class IncorrectAbapDocCheck
extends CommentCheckBase {
    private static final Set<IToken> PROCESSED_COMMENTS = new HashSet<IToken>();

    protected void processComment(IToken firstAbapDocLine, int startLine, int endLine) throws CheckException {
        ArrayList<IToken> commentTokens;
        if (firstAbapDocLine.getText().length() < 2 || firstAbapDocLine.getType() != ETokenType.DOCUMENTATION_COMMENT || firstAbapDocLine.getText().charAt(1) != '!' || PROCESSED_COMMENTS.contains(firstAbapDocLine)) {
            return;
        }
        UnmodifiableList allTokens = this.context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED);
        ShallowEntity commentedEntity = this.getCommentedEntity(firstAbapDocLine, (List<IToken>)allTokens, commentTokens = new ArrayList<IToken>()).orElse(null);
        if (commentedEntity == null || !commentedEntity.getSubtype().equals("method declaration")) {
            return;
        }
        String commentText = commentTokens.stream().map(IToken::getText).collect(Collectors.joining(System.lineSeparator()));
        List abapDocTokens = ScannerUtils.getTokens((String)LanguageProperties.of((ELanguage)this.context.getLanguage()).getCommentContent(commentText), (ELanguage)ELanguage.ABAPDOC, (String)this.context.getUniformPath());
        this.checkComment(abapDocTokens, commentedEntity, commentTokens);
    }

    private void checkComment(List<IToken> abapDocTokens, ShallowEntity relatedEntity, List<IToken> entireComment) {
        Set<String> abapDocParameter = IncorrectAbapDocCheck.findAbapDocParameter(abapDocTokens);
        Set<String> actualParameter = IncorrectAbapDocCheck.findMethodParameter(relatedEntity);
        this.makeFindings(abapDocParameter, actualParameter, entireComment);
    }

    private void makeFindings(Set<String> abapDocParameter, Set<String> actualParameter, List<IToken> entireComment) {
        for (String parameter : abapDocParameter) {
            if (actualParameter.contains(parameter)) continue;
            this.buildFinding("Obsolete AbapDoc Tag: `@parameter %s`".formatted(parameter), this.buildLocation().forTokens(entireComment)).createAndStore();
        }
        for (String actualImport : actualParameter) {
            if (abapDocParameter.contains(actualImport)) continue;
            this.buildFinding("Missing AbapDoc Tag for parameter: `%s`".formatted(actualImport), this.buildLocation().forTokens(entireComment)).createAndStore();
        }
    }

    private static Set<String> findMethodParameter(ShallowEntity entity) {
        List parameters = LanguageFeatureParser.ABAP.getTypeInfoForMethodParameters(entity, (List)entity.includedTokens());
        HashSet<String> methodImports = new HashSet<String>();
        for (TypedVariable variable : parameters) {
            if (!variable.getModifiers().stream().map(IToken::getType).anyMatch(arg_0 -> ETokenType.IMPORTING.equals(arg_0))) continue;
            methodImports.add(variable.getVariableName());
        }
        IncorrectAbapDocCheck.findReturnValue(entity).ifPresent(methodImports::add);
        return methodImports;
    }

    private static Set<String> findAbapDocParameter(List<IToken> commentTokens) {
        HashSet<String> parameterTokens = new HashSet<String>();
        for (int i = 0; i < commentTokens.size(); ++i) {
            if (commentTokens.get(i).getType() != ETokenType.ABAPDOC_TAG || !commentTokens.get(i).getText().equals("@parameter")) continue;
            parameterTokens.add(commentTokens.get(i + 1).getText());
        }
        return parameterTokens;
    }

    private static Optional<String> findReturnValue(ShallowEntity entity) {
        UnmodifiableList declarationTokens = entity.includedTokens();
        Iterator iterator = TokenStreamUtils.firstTokenOfTypeSequences((List)declarationTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.RETURNING, ETokenType.VALUE, ETokenType.LPAREN}).iterator();
        while (iterator.hasNext()) {
            int matchIndex = (Integer)iterator.next();
            if (matchIndex + 3 >= declarationTokens.size()) continue;
            return Optional.of(((IToken)declarationTokens.get(matchIndex + 3)).getText());
        }
        return Optional.empty();
    }

    private Optional<ShallowEntity> getCommentedEntity(IToken commentToken, List<IToken> filteredPreprocessedTokens, List<IToken> commentTokens) throws CheckException {
        int indexOfEnd = filteredPreprocessedTokens.size();
        for (int i = filteredPreprocessedTokens.indexOf(commentToken); i < filteredPreprocessedTokens.size(); ++i) {
            if (filteredPreprocessedTokens.get(i).getType() != ETokenType.DOCUMENTATION_COMMENT) {
                indexOfEnd = i;
                break;
            }
            commentTokens.add(filteredPreprocessedTokens.get(i));
            PROCESSED_COMMENTS.add(filteredPreprocessedTokens.get(i));
        }
        if (indexOfEnd == filteredPreprocessedTokens.size()) {
            return Optional.empty();
        }
        IToken nextToken = filteredPreprocessedTokens.get(indexOfEnd);
        return ShallowEntityTraversalUtils.findContainingEntityDepthFirst((IToken)nextToken, (List)this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED));
    }
}

