/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.abap.AbapCheckUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class MissingAuthorityCheckInObjectBase
extends CheckImplementationBase {
    private static final Set<String> ABAP_CONDITIONAL_STATEMENT_SUBTYPES = Set.of("if", "elseif", "else");

    protected abstract Set<String> getAlternativeAuthorityChecksOption();

    protected boolean isStartingWithAuthorityCheck(ShallowEntity entity) throws CheckException {
        ShallowEntity firstStatement = MissingAuthorityCheckInObjectBase.getFirstNonDeclarativeStatement(entity);
        if (firstStatement == null) {
            return false;
        }
        if (firstStatement.getSubtype().equals("if")) {
            return this.startTokensContainAlternativeAuthorityCheck(firstStatement) || this.allBranchesOfIfStatementHaveAuthorityCheck(firstStatement);
        }
        if (this.isStandardAuthorityCheck(firstStatement)) {
            return true;
        }
        return this.startTokensContainAlternativeAuthorityCheck(firstStatement);
    }

    private boolean startTokensContainAlternativeAuthorityCheck(ShallowEntity statement) throws CheckException {
        String statementText = AbapCheckUtils.getNormalizedStartTokensText((ShallowEntity)statement, (ICheckContext)this.context);
        return this.getAlternativeAuthorityChecksOption().stream().anyMatch(s -> statementText.matches("(?i)" + s));
    }

    private boolean allBranchesOfIfStatementHaveAuthorityCheck(ShallowEntity entity) throws CheckException {
        while (entity != null && ABAP_CONDITIONAL_STATEMENT_SUBTYPES.contains(entity.getSubtype())) {
            if (!this.isStartingWithAuthorityCheck(entity)) {
                return false;
            }
            if (entity.getSubtype().equals("else")) {
                return true;
            }
            entity = ShallowEntityTraversalUtils.getSubsequentSiblingEntity((ShallowEntity)entity);
        }
        return false;
    }

    protected boolean isStandardAuthorityCheck(ShallowEntity firstStatement) {
        return firstStatement.getSubtype().equals("authority-check");
    }

    private static ShallowEntity getFirstNonDeclarativeStatement(ShallowEntity entity) throws CheckException {
        List<ShallowEntity> statements = MissingAuthorityCheckInObjectBase.select((ShallowEntity)entity, (String)".//STATEMENT[not(subtype('data') or subtype('constants')  or subtype('statics') or subtype('tables') or subtype('nodes') or subtype('types') or subtype('field-symbols') or subtype('selection-screen') or subtype('controls') or subtype('infotypes') or subtype('empty statement') or subtype('try') )]");
        if ((statements = MissingAuthorityCheckInObjectBase.removeTrivialAssignmentsAtStart((Collection<ShallowEntity>)statements)).isEmpty()) {
            return null;
        }
        return statements.get(0);
    }

    private static List<ShallowEntity> removeTrivialAssignmentsAtStart(Collection<ShallowEntity> statements) {
        ArrayList<ShallowEntity> result = new ArrayList<ShallowEntity>(statements);
        for (ShallowEntity statement : statements) {
            if (MissingAuthorityCheckInObjectBase.isTrivialAssignmentOrClear((List<IToken>)statement.ownStartTokens())) {
                result.remove(statement);
                continue;
            }
            return result;
        }
        return result;
    }

    private static boolean isTrivialAssignmentOrClear(List<IToken> tokens) {
        return tokens.size() == 3 && TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.CLEAR, ETokenType.IDENTIFIER}) || tokens.size() == 4 && TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.EQ});
    }
}

