/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-to-string-call-on-string", languages={ELanguage.JAVA, ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class ToStringCallOnStringCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (entity.ownStartTokens().isEmpty()) {
            return;
        }
        ScopedTypeLookup lookup = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(entity);
        String toStringName = ToStringCallOnStringCheck.getToStringNameForLanguage(((IToken)entity.ownStartTokens().get(0)).getLanguage());
        List toStringCallsOffsets = TokenStreamTextUtils.findAllSequences((List)entity.ownStartTokens(), (int)0, (ETokenType)ETokenType.DOT, (String[])new String[]{".", toStringName, "(", ")"});
        String findingMessage = "Superfluous " + MarkupUtils.formatAsSourceCode((String)(toStringName + "()")) + " call";
        for (Integer toStringCallOffset : toStringCallsOffsets) {
            TypedVariable typeInfo;
            if (toStringCallOffset == 0) continue;
            IToken tokenBeforeCall = (IToken)entity.ownStartTokens().get(toStringCallOffset - 1);
            if (tokenBeforeCall.getType() == ETokenType.STRING_LITERAL) {
                this.buildFinding(findingMessage, this.buildLocation().forToken((IToken)entity.ownStartTokens().get(toStringCallOffset + 1))).createAndStore();
                continue;
            }
            if (tokenBeforeCall.getType() != ETokenType.IDENTIFIER || !lookup.containsVariable(tokenBeforeCall.getText()) || (typeInfo = lookup.getTypeInfo(tokenBeforeCall.getText())) == null || typeInfo.getTypeNameWithoutGenericTypeParameter() == null || !typeInfo.getTypeNameWithoutGenericTypeParameter().equalsIgnoreCase("string")) continue;
            this.buildFinding(findingMessage, this.buildLocation().forToken((IToken)entity.ownStartTokens().get(toStringCallOffset + 1))).createAndStore();
        }
    }

    private static String getToStringNameForLanguage(ELanguage language) {
        CCSMAssert.isTrue((language == ELanguage.CS || language == ELanguage.JAVA ? 1 : 0) != 0, (String)"Expected only Java or C# as input language");
        if (language == ELanguage.CS) {
            return "ToString";
        }
        return "toString";
    }
}

