/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cloud_smells.config;

import eu.cqse.check.cloud_smells.config.XmlAnyElementAttributeRegexCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

@Check(id="cqse-avoid-hard-coded-path-in-config-file", languages={ELanguage.XML})
public class HardCodedPathInAttributeCheck
extends XmlAnyElementAttributeRegexCheckBase {
    protected static final String CHECK_NAME = "Hard Coded Path in Config File";
    @CheckOption(name="Hard Coded Path in Config File - Allowed drive letters in config files", description="Access to the drive letters specified here is allowed. Separated by commas.")
    private Set<String> allowedDriveLetters = new HashSet<String>();
    @CheckOption(name="Hard Coded Path in Config File - Ignored paths in config files", description="Paths specified here will be ignored. Separated by commas.")
    private Set<String> ignoredPaths = new HashSet<String>();

    @Override
    protected boolean shouldIgnore(String elementName, String localAttributeName, String attributeValue, MatchResult matchResult) {
        boolean isIgnoredPath = this.ignoredPaths.contains(matchResult.group(0));
        boolean isAllowedDrivePath = this.allowedDriveLetters.contains(matchResult.group(1));
        return isAllowedDrivePath || isIgnoredPath;
    }

    @Override
    protected Pattern getUnwantedRegex() {
        return Pattern.compile("(?i)(?<absolutePath>(?<driveLetter>[a-z]):(?:\\\\{1,2}[a-z0-9_\\-\\s\\.]+)+)|(?i)(?<webPath>^\\s*(~)?/[a-z0-9\\-._~%!$&'()*+,;=@#]+(/[a-z0-9\\-._~%!$&'()*+,;=:@#]+)+/?$)");
    }

    @Override
    protected String getFindingText(String elementName, String localAttributeName, String attributeValue, MatchResult matchResult) {
        return CHECK_NAME;
    }
}

