/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cobol;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-cobol-goto-target", languages={ELanguage.COBOL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CobolGotoTargetCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        UnmodifiableList tokens = this.context.getTokens(ECodeViewOption.FILTERED);
        List gotoIndices = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.GO, ETokenType.TO, ETokenType.IDENTIFIER});
        if (gotoIndices.isEmpty()) {
            return;
        }
        PairList<Integer, String> paragraphs = this.getParagraphs(this.context.getRootEntity(ECodeViewOption.FILTERED));
        List<Integer> sectionIndices = this.getSectionIndices(this.context.getRootEntity(ECodeViewOption.FILTERED));
        Iterator iterator = gotoIndices.iterator();
        while (iterator.hasNext()) {
            int gotoIndex = (Integer)iterator.next();
            String gotoLabelName = ((IToken)tokens.get(gotoIndex + 2)).getText().toLowerCase();
            OptionalInt nextSectionStartIndex = CobolGotoTargetCheck.getNextSectionIndex(gotoIndex, sectionIndices);
            OptionalInt previousSectionStartIndex = CobolGotoTargetCheck.getPreviousSectionIndex(gotoIndex, sectionIndices);
            PairList<Integer, String> paragraphsInSection = CobolGotoTargetCheck.getEntriesBetween(previousSectionStartIndex.orElse(Integer.MIN_VALUE), nextSectionStartIndex.orElse(Integer.MAX_VALUE), paragraphs);
            if (paragraphsInSection.isEmpty()) continue;
            String lastParagraphLabel = (String)paragraphsInSection.getSecondList().getLast();
            if (!paragraphsInSection.extractSecondList().contains(gotoLabelName) || lastParagraphLabel.equals(gotoLabelName)) continue;
            this.buildFinding("GO TO does not target last paragraph \"" + MarkupUtils.escapeMarkdownRelevantSymbols((String)lastParagraphLabel) + "\" of current section", this.buildLocation().betweenTokens((IToken)tokens.get(gotoIndex), (IToken)tokens.get(gotoIndex + 2))).createAndStore();
        }
    }

    private static PairList<Integer, String> getEntriesBetween(int previousSectionStartIndex, int nextSectionStartIndex, PairList<Integer, String> paragraphs) {
        return (PairList)paragraphs.stream().filter(pair -> previousSectionStartIndex < (Integer)pair.getFirst() && (Integer)pair.getFirst() < nextSectionStartIndex).collect(PairList.toPairList());
    }

    private static OptionalInt getNextSectionIndex(int index, List<Integer> sectionIndices) {
        return sectionIndices.stream().mapToInt(Integer::intValue).filter(i -> i > index).min();
    }

    private static OptionalInt getPreviousSectionIndex(int index, List<Integer> sectionIndices) {
        return sectionIndices.stream().mapToInt(Integer::intValue).filter(i -> i < index).max();
    }

    private List<Integer> getSectionIndices(ShallowEntity rootEntity) throws CheckException {
        List sectionEntities = CobolGotoTargetCheck.select((ShallowEntity)rootEntity, (String)("//*[type('" + String.valueOf(EShallowEntityType.METHOD) + "') and subtype('section')]"));
        return CollectionUtils.map((Collection)sectionEntities, ShallowEntity::getStartTokenIndex);
    }

    private PairList<Integer, String> getParagraphs(ShallowEntity rootEntity) throws CheckException {
        PairList paragraphIndices = new PairList();
        List paragraphEntities = CobolGotoTargetCheck.select((ShallowEntity)rootEntity, (String)("//*[type('" + String.valueOf(EShallowEntityType.STATEMENT) + "') and subtype('paragraph')]"));
        for (ShallowEntity paragraph : paragraphEntities) {
            paragraphIndices.add((Object)paragraph.getStartTokenIndex(), (Object)paragraph.getName());
        }
        return paragraphIndices;
    }
}

