/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.Nullable;

@Check(id="cqse-cpp-disabled-compiler-warnings", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CppDisabledCompilerWarningsCheck
extends CheckImplementationBase {
    private static final Pattern PRAGMA_DIRECTIVE_PREFIX_PATTERN = Pattern.compile("^#\\s*pragma\\s+");
    private static final Pattern GCC_CLANG_DIAGNOSTIC_IGNORED_PATTERN = Pattern.compile("GCC\\s+diagnostic\\s+ignored\\s*\".*\"");
    private static final Pattern VS_WARNING_DISABLE_PATTERN = Pattern.compile("warning\\s*\\(.*(disable|suppress)\\s*:\\s*[0-9]+.*\\)");

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        List entities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        for (ShallowEntity metaEntity : ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entities, (EShallowEntityType)EShallowEntityType.META)) {
            String pragmaArgument;
            if (!metaEntity.getSubtype().equals("pragma directive") || PreprocessedTokenStreamUtils.containsMacroExpandedContent((List)metaEntity.ownStartTokens()) && !this.isPragmaDirectiveInUnpreprocessedCode(metaEntity) || (pragmaArgument = CppDisabledCompilerWarningsCheck.getPragmaArgument(metaEntity)) == null || pragmaArgument.isEmpty() || !CppDisabledCompilerWarningsCheck.isDisableWarning(pragmaArgument)) continue;
            this.buildFinding("Compiler warning disabled in code", this.buildLocation().forEntity(metaEntity)).createAndStore();
        }
    }

    private boolean isPragmaDirectiveInUnpreprocessedCode(ShallowEntity pragmaDirectiveEntity) throws CheckException {
        if (pragmaDirectiveEntity.ownStartTokens().isEmpty()) {
            return false;
        }
        UnmodifiableList unpreprocessedTokens = this.context.getTokens(ECodeViewOption.FILTERED);
        int indexInUnpreprocessedTokens = TokenStreamUtils.indexOfByOffset((List)unpreprocessedTokens, (int)((IToken)pragmaDirectiveEntity.ownStartTokens().get(0)).getOffset());
        if (indexInUnpreprocessedTokens == -1) {
            return false;
        }
        IToken unpreprocessedToken = (IToken)unpreprocessedTokens.get(indexInUnpreprocessedTokens);
        return PRAGMA_DIRECTIVE_PREFIX_PATTERN.matcher(unpreprocessedToken.getText()).find();
    }

    private static @Nullable String getPragmaArgument(ShallowEntity pragmaDirectiveEntity) {
        UnmodifiableList tokens = pragmaDirectiveEntity.ownStartTokens();
        if (tokens.isEmpty() || ((IToken)tokens.get(0)).getType() != ETokenType.PRAGMA_DIRECTIVE) {
            return null;
        }
        String tokenText = ((IToken)tokens.get(0)).getText();
        Matcher matcher = PRAGMA_DIRECTIVE_PREFIX_PATTERN.matcher(tokenText);
        if (!matcher.find()) {
            return null;
        }
        return tokenText.substring(matcher.end()).trim();
    }

    private static boolean isDisableWarning(String argument) {
        return GCC_CLANG_DIAGNOSTIC_IGNORED_PATTERN.matcher(argument).matches() || VS_WARNING_DISABLE_PATTERN.matcher(argument).matches();
    }
}

