/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.clike.MemberVisibilityOrderCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.enums.EnumUtils;

@Check(id="cqse-cpp-member-visibility-order", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CppMemberVisibilityOrderCheck
extends MemberVisibilityOrderCheckBase {
    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    @Override
    protected List<ETokenType> getOrderedModifier() {
        return Arrays.asList(ETokenType.PUBLIC, ETokenType.PROTECTED, ETokenType.PRIVATE);
    }

    @Override
    protected String getClassEntitiesXPath() {
        return "//TYPE[subtype('class') or subtype('struct')]";
    }

    @Override
    protected String getMemberXPathSelection() {
        return "./META[subtype('public') | subtype('protected') | subtype('private')]";
    }

    @Override
    protected Optional<String> getFindingsMessage(Pair<ETokenType, ShallowEntity> member, ETokenType precedingModifier) {
        return Optional.of("`" + ((ETokenType)member.getFirst()).toString().toLowerCase() + "` access modifier should not be after `" + precedingModifier.toString().toLowerCase() + "`. Expected order: " + CppMemberVisibilityOrderCheck.getOrderString(this.MODIFIER_ORDER));
    }

    @Override
    protected ETokenType getAccessModifierFromMember(ShallowEntity member) {
        return (ETokenType)EnumUtils.valueOfIgnoreCase(ETokenType.class, (String)member.getSubtype());
    }
}

