/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.cpp.HeaderFileCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-header-global-using", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class HeaderGlobalUsingCheck
extends HeaderFileCheckBase {
    @Override
    public void executeHeaderCheck() throws CheckException {
        List metaEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.META);
        ArrayList<ShallowEntity> violatingEntities = new ArrayList<ShallowEntity>();
        for (ShallowEntity metaEntity : metaEntities) {
            if (!"using".equals(metaEntity.getSubtype()) && !"using namespace".equals(metaEntity.getSubtype()) || this.hasTypeOrMethodAncestor(metaEntity) || HeaderGlobalUsingCheck.isTypeAlias(metaEntity)) continue;
            violatingEntities.add(metaEntity);
        }
        for (ShallowEntity entity : violatingEntities) {
            this.buildFinding("Do not use `using` outside of functions/methods/classes in headers", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private boolean hasTypeOrMethodAncestor(ShallowEntity metaEntity) {
        return ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)metaEntity, ancestor -> ancestor.getType() == EShallowEntityType.TYPE || ancestor.getType() == EShallowEntityType.METHOD).isPresent();
    }

    private static boolean isTypeAlias(ShallowEntity usingEntity) {
        return TokenStreamUtils.containsAny((List)usingEntity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.EQ});
    }
}

