/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.cpp.misra.TokenFilterCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

@Check(id="cqse-macro-name", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MacroNameCheck
extends TokenFilterCheckBase {
    private static final String FINDING_MESSAGE_PATTERN = "Macro name `%s` should only contain uppercase letters, digits, and underscores (not as leading character)";
    private static final Pattern MACRO_NAME_PATTERN = Pattern.compile("[A-Z0-9]+[_A-Z0-9]*");
    @CheckOption(name="Ignored macros", description="List of ignored macro names, comma or newline separated.", multilineText=true)
    private List<String> multilineIgnoredMacroNames = Arrays.asList("bool", "true", "false");

    @Override
    protected boolean isValidToken(IToken token) {
        if (!MacroDefinition.isMacroDefinition((IToken)token)) {
            return true;
        }
        MacroDefinition macroDefinition = MacroDefinition.fromToken((IToken)token);
        String macroName = macroDefinition.macroName;
        return this.multilineIgnoredMacroNames.contains(macroName) || MACRO_NAME_PATTERN.matcher(macroName).matches();
    }

    @Override
    protected String getFindingMessage(IToken token) {
        return String.format(FINDING_MESSAGE_PATTERN, MacroDefinition.fromToken((IToken)token).macroName);
    }
}

