/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeInfoExtractor;
import eu.cqse.check.framework.typetracker.TypeInfoExtractorFactory;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-subsequent-same-type-parameter", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SubsequentSameTypeParameterCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Method %s has %s (limit is %s) subsequent parameters of type %s";
    private static final String FINDING_PROPERTY_KEY = "Number of subsequent parameters of same type";
    @CheckOption(name="Maximum number of subsequent parameters of same type", description="The maximum number of subsequent parameters inside method declarations which are allowed to have the same type.")
    private int maximumSubsequentSameTypeParameters = 2;

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity methodEntity) {
        if (SubsequentSameTypeParameterCheck.isDerivedMethod(methodEntity)) {
            return;
        }
        Pair<String, Integer> violatingTypeWithOccurrences = this.findFirstViolatingParameterTypeWithOccurrence(methodEntity);
        if (violatingTypeWithOccurrences != null && !"<unknown type>".equals(violatingTypeWithOccurrences.getFirst())) {
            String numberOfSubsequentParameters = ((Integer)violatingTypeWithOccurrences.getSecond()).toString();
            String formattedFindingMessage = String.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)methodEntity.getName()), MarkupUtils.formatAsSourceCode((String)numberOfSubsequentParameters), this.maximumSubsequentSameTypeParameters, MarkupUtils.formatAsSourceCode((String)((String)violatingTypeWithOccurrences.getFirst())));
            this.buildFinding(formattedFindingMessage, this.buildLocation().forTokens((List)methodEntity.ownStartTokens())).addFindingProperties(FindingPropertyList.singleton((String)FINDING_PROPERTY_KEY, (String)numberOfSubsequentParameters)).createAndStore();
        }
    }

    private Pair<String, Integer> findFirstViolatingParameterTypeWithOccurrence(ShallowEntity methodEntity) {
        ITypeInfoExtractor typeInfoExtractor = TypeInfoExtractorFactory.getTypeInfoExtractor((ELanguage)this.context.getLanguage(), null);
        if (typeInfoExtractor == null) {
            return null;
        }
        List methodParameters = typeInfoExtractor.extract(methodEntity);
        String previousType = "";
        int occurrences = 0;
        for (TypedVariable parameter : methodParameters) {
            String currentType = parameter.getTypeName();
            if (!currentType.equals(previousType)) {
                if (occurrences > this.maximumSubsequentSameTypeParameters) {
                    return new Pair((Object)previousType, (Object)occurrences);
                }
                occurrences = 1;
                previousType = currentType;
                continue;
            }
            ++occurrences;
        }
        if (occurrences > this.maximumSubsequentSameTypeParameters) {
            return new Pair((Object)previousType, (Object)occurrences);
        }
        return null;
    }

    private static boolean isDerivedMethod(ShallowEntity methodEntity) {
        return TokenStreamUtils.containsAny((List)methodEntity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.NEW, ETokenType.OVERRIDE});
    }
}

