/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-functions-in-prototype-form", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class FunctionsInPrototypeFormCheck
extends CheckImplementationBase {
    @CheckOption(name="Force to explicitly specify void for functions without parameters", description="Enable this to check Misra conformance. In C a function with the following signature 'int foo()' takes an unspecified number of arguments. To explicitly specify that the function takes no arguments void should be used eg. 'int foo(void)'. In C++ this is not the case and enabling this check leads to false positives.")
    private boolean checkVoidForEmptyParameters = false;
    private static final TokenPattern FUNCTION_POINTER_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.LPAREN, ETokenType.MULT, ETokenType.IDENTIFIER, ETokenType.RPAREN}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false).group(0);

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        HashSet<String> namesOfTypesDefinedInCurrentFile = new HashSet<String>();
        List entities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        for (ShallowEntity type : ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entities, (EShallowEntityType)EShallowEntityType.TYPE)) {
            namesOfTypesDefinedInCurrentFile.add(type.getName());
            if (!type.getSubtype().equals("typedef")) continue;
            this.processTypedef(type);
        }
        for (ShallowEntity method : ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entities, (EShallowEntityType)EShallowEntityType.METHOD)) {
            if (method.getSubtype().equals("function declaration")) {
                this.processFunctionDeclaration(method, namesOfTypesDefinedInCurrentFile);
                continue;
            }
            if (!method.getSubtype().equals("function") && !method.getSubtype().equals("function pointer declaration")) continue;
            this.processMethod(method);
        }
    }

    private void processFunctionDeclaration(ShallowEntity functionDeclarationEntity, Set<String> namesOfDefinedTypes) throws CheckException {
        List parameters = LanguageFeatureParser.CPP.getSplitParameterTokens(functionDeclarationEntity);
        if (!FunctionsInPrototypeFormCheck.areArgumentsForConstructorInvocation(parameters, namesOfDefinedTypes)) {
            this.processParameters(functionDeclarationEntity, parameters);
        }
    }

    private static boolean areArgumentsForConstructorInvocation(List<List<IToken>> parameters, Set<String> namesOfDefinedTypes) {
        if (parameters.isEmpty()) {
            return false;
        }
        for (List<IToken> parameter : parameters) {
            if (FunctionsInPrototypeFormCheck.isCppArgument(parameter)) {
                return true;
            }
            if (!FunctionsInPrototypeFormCheck.isCppDataType(TokenStreamTextUtils.concatTokenTexts(parameter), namesOfDefinedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCppArgument(List<IToken> parameter) {
        if (parameter.size() == 1) {
            return parameter.get(0).getType().isLiteral();
        }
        for (IToken token : parameter) {
            ETokenType currentType = token.getType();
            if (currentType != ETokenType.LBRACE && currentType != ETokenType.DOT && currentType != ETokenType.COMMA) continue;
            return true;
        }
        return false;
    }

    private static boolean isCppDataType(String parameterName, Set<String> namesOfDefinedTypes) {
        return parameterName.endsWith("_t") || namesOfDefinedTypes.contains(parameterName);
    }

    private void processTypedef(ShallowEntity entity) throws CheckException {
        TokenPatternMatch match = FUNCTION_POINTER_PATTERN.findFirstMatch((List)entity.ownStartTokens());
        if (match == null) {
            return;
        }
        List parameterTokens = TokenStreamUtils.tokensBetweenWithNesting((List)match.groupTokens(0), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        this.processParameters(entity, LanguageFeatureParser.CPP.splitVariableTokens(parameterTokens));
    }

    private void processMethod(ShallowEntity entity) throws CheckException {
        List parameters = LanguageFeatureParser.CPP.getSplitParameterTokens(entity);
        if (FunctionsInPrototypeFormCheck.isTemplatedMethod(entity) && this.allMethodParametersAreInTemplateSpecialization(entity, parameters)) {
            return;
        }
        this.processParameters(entity, parameters);
    }

    private void processParameters(ShallowEntity entity, List<List<IToken>> parameters) throws CheckException {
        if (parameters.isEmpty() && this.checkVoidForEmptyParameters) {
            this.buildFinding("Not in prototype form, missing ``void`` in parameter list", this.buildLocation().forTokens((List)entity.ownStartTokens())).createAndStore();
            return;
        }
        for (List<IToken> parameter : parameters) {
            if (parameter.isEmpty()) continue;
            if (parameter.get(0).getType() == ETokenType.VOID || TokenStreamUtils.contains(parameter, (ETokenType)ETokenType.ELLIPSIS)) {
                return;
            }
            parameter = FunctionsInPrototypeFormCheck.substituteWhereToken(parameter);
            String type = FunctionsInPrototypeFormCheck.getParameterType(this.context, parameter);
            IToken variableName = FunctionsInPrototypeFormCheck.getParameterVariableName(this.context, parameter);
            if (variableName != null && !StringUtils.isEmpty((String)type) || entity.getSubtype().equals("function") && this.isCommentedParameterName(parameter)) continue;
            this.buildFinding("Not all parameter names are specified", this.buildLocation().forTokens((List)entity.ownStartTokens())).createAndStore();
            return;
        }
    }

    private static String getParameterType(ICheckContext context, List<IToken> parameter) {
        if (context.getLanguage() == ELanguage.CPP || context.getLanguage() == ELanguage.CPP_MS_CLI) {
            return LanguageFeatureParser.CPP.getVariableTypeFromTokens(parameter);
        }
        return LanguageFeatureParser.C.getVariableTypeFromTokens(parameter);
    }

    private static IToken getParameterVariableName(ICheckContext context, List<IToken> parameter) {
        if (context.getLanguage() == ELanguage.CPP || context.getLanguage() == ELanguage.CPP_MS_CLI) {
            return LanguageFeatureParser.CPP.getVariableNameFromTokens(parameter);
        }
        return LanguageFeatureParser.C.getVariableNameFromTokens(parameter);
    }

    private static boolean isTemplatedMethod(ShallowEntity entity) {
        ShallowEntity previousEntity = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)entity);
        if (previousEntity == null) {
            return false;
        }
        return previousEntity.getSubtype().equals("template");
    }

    private boolean allMethodParametersAreInTemplateSpecialization(ShallowEntity methodEntity, List<List<IToken>> methodParameters) throws CheckException {
        ShallowEntity templateEntity = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)methodEntity);
        List<List<IToken>> templateParameters = FunctionsInPrototypeFormCheck.getTemplateParameters(templateEntity);
        for (List<IToken> methodParameter : methodParameters) {
            if (FunctionsInPrototypeFormCheck.existsInTemplateParameters(methodParameter, templateParameters) || this.isCommentedParameterName(methodParameter)) continue;
            return false;
        }
        return true;
    }

    private static List<List<IToken>> getTemplateParameters(ShallowEntity templateEntity) {
        if (templateEntity == null) {
            return Collections.emptyList();
        }
        List templateParameters = TokenStreamUtils.tokensBetweenWithNesting((List)templateEntity.ownStartTokens(), (ETokenType)ETokenType.LT, (ETokenType)ETokenType.GT);
        return LanguageFeatureParser.CPP.splitVariableTokens(templateParameters);
    }

    private static boolean existsInTemplateParameters(List<IToken> methodParameter, List<List<IToken>> templateParameters) {
        for (List<IToken> templateParameter : templateParameters) {
            if (!methodParameter.stream().anyMatch(token -> TokenStreamUtils.getTokenByTypeAndText((List)templateParameter, (String)token.getText(), Collections.singleton(token.getType())) != null)) continue;
            return true;
        }
        return false;
    }

    private boolean isCommentedParameterName(List<IToken> parameter) throws CheckException {
        UnmodifiableList tokens = this.context.getTokens(this.getCodeViewOption());
        int parameterIndex = TokenStreamUtils.indexOfByOffset((List)tokens, (int)parameter.get(0).getOffset());
        return parameterIndex + parameter.size() < tokens.size() && ((IToken)tokens.get(parameterIndex + parameter.size())).getType() == ETokenType.TRADITIONAL_COMMENT;
    }

    private static List<IToken> substituteWhereToken(List<IToken> tokens) {
        ArrayList<IToken> tokensWithSubstitutions = new ArrayList<IToken>();
        for (IToken token : tokens) {
            if (token.getType() == ETokenType.WHERE) {
                token = token.newToken(ETokenType.IDENTIFIER, token.getOffset(), token.getLineNumber(), token.getText(), token.getOriginId());
            }
            tokensWithSubstitutions.add(token);
        }
        return tokensWithSubstitutions;
    }
}

