/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.cpp.misra.TokenFilterCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.EnumSet;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-terminated-escape-sequences", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class TerminatedEscapeSequencesCheck
extends TokenFilterCheckBase {
    private static final int MAX_DELIMITER_LENGTH = 16;
    private static final EnumSet<ETokenType> CHECKED_TOKENTYPES = EnumSet.of(ETokenType.STRING_LITERAL, ETokenType.CHARACTER_LITERAL);
    private static final Pattern UNTERMINATED_OCTAL_OR_HEXADECIMAL_SEQUENCE = Pattern.compile("(?<!\\\\)(\\\\[0-7]{1,3}+|\\\\x[0-9a-fA-F]++|\\\\u[0-9a-fA-F]{4}+|\\\\U[0-9a-fA-F]{8})[^'\"\\\\]");
    private static final Pattern PREFIX_SEQUENCE = Pattern.compile("(L|U|u|u8)?R.*");

    @Override
    protected String getFindingMessage(IToken token) {
        return "`" + TerminatedEscapeSequencesCheck.getFirstNonterminatedOctalOrHexadecimalEscapeSequence(token).get() + "` is expected to be terminated by another escape sequence or the end of the literal";
    }

    private static Optional<String> getFirstNonterminatedOctalOrHexadecimalEscapeSequence(IToken token) {
        Matcher matcher = UNTERMINATED_OCTAL_OR_HEXADECIMAL_SEQUENCE.matcher(token.getText());
        if (matcher.find()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    @Override
    protected boolean isValidToken(IToken token) {
        if (!CHECKED_TOKENTYPES.contains(token.getType())) {
            return true;
        }
        if (TerminatedEscapeSequencesCheck.isRawString(token.getText())) {
            return true;
        }
        return !TerminatedEscapeSequencesCheck.getFirstNonterminatedOctalOrHexadecimalEscapeSequence(token).isPresent();
    }

    private static boolean isRawString(String tokenText) {
        Matcher prefixMatcher = PREFIX_SEQUENCE.matcher(tokenText);
        if (prefixMatcher.matches()) {
            int index = tokenText.indexOf("\"");
            String body = tokenText.substring(index + 1, tokenText.length() - 1);
            String delimiter = StringUtils.getFirstPart((String)body, (String)"(");
            return delimiter.length() <= 16;
        }
        return false;
    }
}

