/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.preprocessor;

import eu.cqse.check.cpp.misra.TokenFilterCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

@Check(id="cqse-forbidden-sequences-in-include", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ForbiddenSequencesInIncludeCheck
extends TokenFilterCheckBase {
    private static final EnumSet<ETokenType> CHECKED_TOKENTYPES = EnumSet.of(ETokenType.PREPROCESSOR_INCLUDE);
    private static final List<String> FORBIDDEN_SEQUENCES = Arrays.asList("'", "\"", "\\", "/*", "//");

    @Override
    protected String getFindingMessage(IToken token) {
        String includeFileName = ForbiddenSequencesInIncludeCheck.getIncludeFileName(token);
        String foundForbiddenSequences = FORBIDDEN_SEQUENCES.stream().filter(includeFileName::contains).map(sequence -> "`" + sequence + "`").collect(Collectors.joining(", "));
        return foundForbiddenSequences + " should not be part of `" + token.getText() + "`";
    }

    private static String getIncludeFileName(IToken token) {
        String[] parts = token.getText().split("[^#\\s]\\s+", 2);
        if (parts.length < 2) {
            return "";
        }
        String includeFileName = parts[1].trim();
        return includeFileName.substring(1, includeFileName.length() - 1);
    }

    private static boolean containsForbiddenSequences(String includeFileName) {
        return FORBIDDEN_SEQUENCES.stream().anyMatch(includeFileName::contains);
    }

    @Override
    protected boolean isValidToken(IToken token) {
        if (!CHECKED_TOKENTYPES.contains(token.getType())) {
            return true;
        }
        return !ForbiddenSequencesInIncludeCheck.containsForbiddenSequences(ForbiddenSequencesInIncludeCheck.getIncludeFileName(token));
    }
}

