/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-avoid-using-certain-text-snippets", languages={ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.OPEN_CL, ELanguage.RUST, ELanguage.VB, ELanguage.COBOL, ELanguage.CS, ELanguage.ABAP, ELanguage.ADA, ELanguage.TEXT, ELanguage.XML, ELanguage.SQLSCRIPT, ELanguage.HANA_VIEW, ELanguage.PLSQL, ELanguage.PYTHON, ELanguage.TSQL, ELanguage.MATLAB, ELanguage.PHP, ELanguage.JAVASCRIPT, ELanguage.LINE, ELanguage.DELPHI, ELanguage.IEC61131, ELanguage.FORTRAN, ELanguage.XTEND, ELanguage.SWIFT, ELanguage.OCAML, ELanguage.OSCRIPT, ELanguage.GROOVY, ELanguage.GOSU, ELanguage.KOTLIN, ELanguage.OBJECTIVE_C, ELanguage.JAVADOC, ELanguage.ESQL, ELanguage.GO})
public class AvoidUsingCertainTextSnippetsCheck
extends CheckImplementationBase {
    @CheckOption(name="Text snippets to avoid", description="The comma separated list of text snippets that should be avoided (case sensitive). Commas in text snippets need to be escaped by a backslash '\\\\,'")
    private Set<String> snippetsToAvoid = new HashSet<String>();

    public void execute() throws CheckException {
        String[] textContentLines = StringUtils.splitLines((String)this.context.getTextContent(ECodeViewOption.ETextViewOption.UNFILTERED_CONTENT));
        for (String word : this.snippetsToAvoid) {
            for (int i = 0; i < textContentLines.length; ++i) {
                String line = textContentLines[i];
                if (!line.contains(word)) continue;
                this.buildFinding("Avoid using " + MarkupUtils.formatAsSourceCode((String)word) + ".", this.buildLocation().forLine(i + 1, ECodeViewOption.ETextViewOption.UNFILTERED_CONTENT)).createAndStore();
            }
        }
    }
}

