/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.NonNull;

@Check(id="cqse-throw-in-finally", languages={ELanguage.CS, ELanguage.GROOVY, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.KOTLIN, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.PHP, ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ThrowInFinallyCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Exception thrown in `finally` block";

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private static boolean isObjcRaiser(@NonNull UnmodifiableList<IToken> tokens) {
        return tokens.size() >= 3 && ((IToken)tokens.get(2)).getText().equals("raise");
    }

    private static boolean isThrowStatement(@NonNull UnmodifiableList<IToken> tokens) {
        return !tokens.isEmpty() && ((IToken)tokens.get(0)).getType() == ETokenType.THROW;
    }

    private boolean shouldIgnoreEntity(ShallowEntity entity) {
        if (PreprocessorUtils.hasPreprocessor((ELanguage)this.context.getLanguage()) && PreprocessedTokenStreamUtils.firstTokenOfTypeIsFromMacro((List)entity.ownStartTokens(), EnumSet.of(ETokenType.THROW))) {
            return true;
        }
        if (this.context.getLanguage().isObjectiveCOrObjectiveCpp()) {
            if (ThrowInFinallyCheck.isThrowStatement((UnmodifiableList<IToken>)entity.ownStartTokens())) {
                return false;
            }
            return !ThrowInFinallyCheck.isObjcRaiser((UnmodifiableList<IToken>)entity.ownStartTokens()) || PreprocessedTokenStreamUtils.firstTokenOfTypeIsFromMacro((List)entity.ownStartTokens(), EnumSet.of(ETokenType.LBRACK));
        }
        return false;
    }

    public void execute() throws CheckException {
        String targetSubtype = this.context.getLanguage().isObjectiveCOrObjectiveCpp() ? "@finally" : "finally";
        List statementsInFinally = ShallowEntityTraversalUtils.findNestedEntities((List)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT, entity -> targetSubtype.equals(entity.getSubtype()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        if (this.context.getLanguage().isObjectiveCOrObjectiveCpp()) {
            this.processFinallyBlockInObjectiveC(statementsInFinally);
        } else {
            this.processFinallyBlockInOtherLanguages(statementsInFinally);
        }
    }

    private void processFinallyBlockInOtherLanguages(List<ShallowEntity> statementsInFinally) {
        for (ShallowEntity statementInFinally : statementsInFinally) {
            if (!"simple statement".equals(statementInFinally.getSubtype()) || this.shouldIgnoreEntity(statementInFinally) || (this.context.getLanguage() != ELanguage.PYTHON || !TokenStreamUtils.contains((List)statementInFinally.ownStartTokens(), (ETokenType)ETokenType.RAISE)) && !TokenStreamUtils.contains((List)statementInFinally.ownStartTokens(), (ETokenType)ETokenType.THROW)) continue;
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntity(statementInFinally)).createAndStore();
        }
    }

    private void processFinallyBlockInObjectiveC(List<ShallowEntity> statementsInFinally) {
        for (ShallowEntity statementInFinally : statementsInFinally) {
            if (!"simple statement".equals(statementInFinally.getSubtype()) || this.shouldIgnoreEntity(statementInFinally) || !TokenStreamUtils.contains((List)statementInFinally.ownStartTokens(), (ETokenType)ETokenType.THROW) && !TokenStreamUtils.containsSequence((List)statementInFinally.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.LBRACK, ETokenType.IDENTIFIER, ETokenType.IDENTIFIER, ETokenType.RBRACK}) && !TokenStreamUtils.containsSequence((List)statementInFinally.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.LBRACK, ETokenType.IDENTIFIER, ETokenType.IDENTIFIER, ETokenType.COLON})) continue;
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntity(statementInFinally)).createAndStore();
        }
    }
}

