/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.formatting;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@Check(id="cqse-multiple-variable-declarations", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVA, ELanguage.CS, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.JAVASCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MultipleVariableDeclarationsCheck
extends CheckImplementationBase {
    private static final List<ETokenType> ALL_OPEN_PAREN = Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LT, ETokenType.LBRACK);
    private static final List<ETokenType> ALL_CLOSE_PAREN = Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.GT, ETokenType.RBRACK);

    public void execute() throws CheckException {
        List entities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        List<ShallowEntity> multipleDeclarations = entities.stream().filter(entity -> entity.getType() == EShallowEntityType.STATEMENT && "local variable".equals(entity.getSubtype()) || entity.getType() == EShallowEntityType.ATTRIBUTE && "attribute".equals(entity.getSubtype())).filter(entity -> TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.COMMA)).toList();
        for (ShallowEntity entity2 : multipleDeclarations) {
            this.processEntity(entity2);
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (!entity.isCompleted()) {
            return;
        }
        if (this.context.getLanguage().isCppOrC() && MultipleVariableDeclarationsCheck.isBitFieldDeclaration(entity)) {
            return;
        }
        List declarations = TokenStreamUtils.splitWithNesting((List)entity.ownStartTokens(), (ETokenType)ETokenType.COMMA, ALL_OPEN_PAREN, ALL_CLOSE_PAREN);
        if (declarations.size() > 1 && !((List)declarations.get(1)).isEmpty()) {
            List<String> names = MultipleVariableDeclarationsCheck.getVariableNames(declarations);
            this.buildFinding("Each variable should be declared on a separate statement: " + MultipleVariableDeclarationsCheck.joinLimitedWithCountSuffix(names, ", ", 4), this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private static boolean isBitFieldDeclaration(ShallowEntity entity) {
        if (!entity.getSubtype().equals("attribute")) {
            return false;
        }
        UnmodifiableList tokens = entity.ownStartTokens();
        return TokenStreamUtils.contains((List)tokens, (ETokenType)ETokenType.COLON);
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> getVariableNames(List<List<IToken>> declarations) {
        ArrayList<String> names = new ArrayList<String>();
        block0: for (List<IToken> list : declarations) {
            List initialization = TokenStreamUtils.splitWithNesting(list, (ETokenType)ETokenType.EQ, ALL_OPEN_PAREN, ALL_CLOSE_PAREN);
            if (initialization.size() > 1) {
                List list2 = (List)initialization.get(0);
            }
            for (int i = var3_3.size() - 1; i >= 0; --i) {
                void var3_3;
                if (((IToken)var3_3.get(i)).getType() != ETokenType.IDENTIFIER) continue;
                names.add(((IToken)var3_3.get(i)).getText());
                continue block0;
            }
        }
        return names;
    }

    private static String joinLimitedWithCountSuffix(@NonNull List<String> items, String delimiter, int limit) {
        if (items.size() <= limit || limit < 1) {
            return StringUtils.joinDifferentLastDelimiter(items, (String)delimiter, (String)" and ");
        }
        ArrayList<String> limitedItems = new ArrayList<String>(items.subList(0, limit));
        limitedItems.add(String.format("%d more", items.size() - limit));
        return StringUtils.joinDifferentLastDelimiter(limitedItems, (String)delimiter, (String)" and ");
    }
}

