/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.general;

import eu.cqse.check.base.HardCodedLiteralsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import java.util.regex.Pattern;

@Check(id="cqse-hard-coded-password", languages={ELanguage.ABAP, ELanguage.JAVA, ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.ESQL, ELanguage.GOSU, ELanguage.GROOVY, ELanguage.JAVASCRIPT, ELanguage.KOTLIN, ELanguage.RUST, ELanguage.XTEND, ELanguage.SWIFT, ELanguage.PHP, ELanguage.VB, ELanguage.PYTHON, ELanguage.GO}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class HardCodedPasswordCheck
extends HardCodedLiteralsCheckBase {
    private static final String CHECK_NAME = "Hard-coded password";
    @CheckOption(name="Hard-coded password - Restrict to password rule", description="Regular expressions for password rule which must match, e.g. '^(?!.*(https?://|www))(?=.*[A-Za-z])(?=.*\\d)\\S{5,}$' for 'at least one alphabet letter, at least one digit, no white spaces and minimum length of 5 characters'.Moreover it cant start with 'www', 'http' or 'https' since that indicates an URL")
    private String passwordRegex = "^(?!.*(https?://|www))(?=.*[A-Za-z])(?=.*\\d)\\S{5,}$";
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("(?i).*(pass.?word|pwd|pass?wr?d|auth.*token|passwort|kennwort).*");

    protected String getFindingsMessageText() {
        return CHECK_NAME;
    }

    protected boolean isMatchingIdentifier(IToken identifier) {
        return IDENTIFIER_PATTERN.matcher(identifier.getText()).matches();
    }

    protected void createFindingForLiteral(IToken literal) throws CheckException {
        this.buildFinding(this.getFindingsMessageText(), this.buildLocation().forToken(literal)).createAndStore();
    }

    protected String getLiteralRegex() {
        return this.passwordRegex;
    }
}

