/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.gosu;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-no-java-equals", languages={ELanguage.GOSU}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoJavaEqualsCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!TokenStreamUtils.containsSequence((List)statement.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN})) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        for (Integer dotIndex : TokenStreamUtils.findAll((List)tokens, (ITokenMatcher)ETokenType.DOT)) {
            int nextIndex = dotIndex + 1;
            if (nextIndex >= tokens.size() || !NoJavaEqualsCheck.isEquals((IToken)tokens.get(nextIndex))) continue;
            this.buildFinding("The usage of `equals` is discouraged. Use the comparison operators `==` and `!=` instead", this.buildLocation().forToken((IToken)tokens.get(nextIndex))).createAndStore();
        }
    }

    private static boolean isEquals(IToken token) {
        boolean isIdentifier = token.getType().equals((Object)ETokenType.IDENTIFIER);
        boolean isEsquals = "equals".equals(token.getText());
        return isIdentifier && isEsquals;
    }
}

