/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.gosu;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-no-public-variables", languages={ELanguage.GOSU}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoPublicVariables
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        for (ShallowEntity attribute : attributes) {
            UnmodifiableList tokens = attribute.ownStartTokens();
            int publicAttributeIndex = TokenStreamUtils.firstTokenOfTypeSequence((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.VAR, ETokenType.IDENTIFIER});
            if (publicAttributeIndex == -1 || TokenStreamUtils.containsSequence((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.AS, ETokenType.IDENTIFIER})) continue;
            this.buildFinding(NoPublicVariables.buildFindingMessage(attribute), this.buildLocation().forEntity(attribute)).createAndStore();
        }
    }

    private static String buildFindingMessage(ShallowEntity entity) {
        return "`" + entity.getName() + "` should not be public. Expose it as a property instead";
    }
}

