/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.hana_views;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.hana_views.HanaViewsCheckUtil;
import eu.cqse.check.xml.AttributeRegexCheckBase;
import java.util.regex.Pattern;

@Check(id="cqse-field-names-must-not-contain-special-characters", languages={ELanguage.HANA_VIEW})
public class FieldNamesMustNotContainSpecialCharactersCheck
extends AttributeRegexCheckBase {
    @CheckOption(name="Regex describing allowed identifier names (expert option)", description="SAP HANA reference uses '^[a-zA-Z_0-9]+$' as allowed identifiers. This option can be used to provide a custom specification.")
    private String allowedIdentifierRegex = "^[a-zA-Z_0-9]+$";

    public FieldNamesMustNotContainSpecialCharactersCheck() {
        super(HanaViewsCheckUtil.FIELD_ELEMENTS, "id", false);
    }

    @Override
    protected String getFindingsMessage() {
        return "Field name contains special character";
    }

    @Override
    protected Pattern getPattern() {
        return Pattern.compile(this.allowedIdentifierRegex);
    }
}

