/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-class-named-exception-should-extend-exception", languages={ELanguage.JAVA, ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ClassNamedExceptionShouldExtendExceptionCheck
extends CheckImplementationBase {
    private static final TokenPattern PARENT_CLASS_EXCEPTION_PATTERN = new TokenPattern().alternative(new Object[]{LanguageFeatureParser.JAVA.classExtendsPattern(), LanguageFeatureParser.CS.classExtendsPattern()}).regex("\\w*([eE]xception)|Throwable\\w*");

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (!"class".equals(type.getSubtype())) continue;
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity typeEntity) {
        if (typeEntity.getName() == null || !StringUtils.endsWithIgnoreCase((String)typeEntity.getName(), (String)"exception")) {
            return;
        }
        UnmodifiableList classDefinitionTokens = typeEntity.ownStartTokens();
        TokenPatternMatch match = PARENT_CLASS_EXCEPTION_PATTERN.findFirstMatch((List)classDefinitionTokens);
        if (match == null) {
            IToken findingLocation = (IToken)classDefinitionTokens.get(TokenStreamUtils.firstTokenMatching((List)classDefinitionTokens, (ITokenMatcher)ETokenType.IDENTIFIER));
            this.buildFinding("`" + typeEntity.getName() + "` should inherit from `Exception` or subclass", this.buildLocation().forToken(findingLocation)).createAndStore();
        }
    }
}

