/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="java:S5344", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotStorePasswordsInsecurelyCheck
extends CheckImplementationBase {
    private static final Set<String> UNSAFE_PASSWORD_ENCODER_CONSTRUCTORS = CollectionUtils.asHashSet((Object[])new String[]{"org.springframework.security.authentication.encoding.ShaPasswordEncoder", "org.springframework.security.authentication.encoding.Md5PasswordEncoder", "org.springframework.security.crypto.password.LdapShaPasswordEncoder", "org.springframework.security.crypto.password.Md4PasswordEncoder", "org.springframework.security.crypto.password.MessageDigestPasswordEncoder", "org.springframework.security.crypto.password.StandardPasswordEncoder", "org.springframework.security.crypto.scrypt.SCryptPasswordEncoder", "org.springframework.security.crypto.password.NoOpPasswordEncoder"});
    private static final JavaMethodCallMatcher INSECURE_ENCODER_CONSTRUCTOR_MATCHER = JavaMethodCallMatcher.create().onTypes(UNSAFE_PASSWORD_ENCODER_CONSTRUCTORS).constructorsAndGetInstanceCalls();
    private static final JavaMethodCallMatcher AUTHENTICATION_CONFIGURATION_CALL_MATCHER = JavaMethodCallMatcher.create().onTypes(new String[]{"org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder"}).withTargetMethodNames(new String[]{"jdbcAuthentication", "userDetailsService"});

    public void execute() throws CheckException {
        if (LanguageFeatureParser.JAVA.getImportsByPrefix((List)this.getRootChildren(), new String[]{"org.springframework."}).isEmpty()) {
            return;
        }
        ShallowEntity rootEntity = this.context.getRootEntity(this.getCodeViewOption());
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(rootEntity);
        this.checkForInsecureEncoderInstantiations(rootEntity, typeResolver);
        this.checkForInsecureDefaultEncoders(rootEntity, typeResolver);
    }

    private void checkForInsecureDefaultEncoders(ShallowEntity rootEntity, JavaImportSensitiveTypeResolver typeResolver) throws CheckException {
        List authenticationCalls = AUTHENTICATION_CONFIGURATION_CALL_MATCHER.find(rootEntity, this.context.getTypeResolution(this.getCodeViewOption()), typeResolver);
        TokenPattern passwordEncoderPattern = new TokenPattern().sequence(new Object[]{ETokenType.DOT}).tokenText("passwordEncoder").sequence(new Object[]{ETokenType.LPAREN});
        for (JavaMethodCallMatcher.MethodCall passwordEncoderCall : authenticationCalls) {
            if (passwordEncoderPattern.matchesAnywhere((List)passwordEncoderCall.entity().includedTokens())) continue;
            this.buildFinding("Don't use the default `PasswordEncoder` relying on plain-text", this.buildLocation().forToken(passwordEncoderCall.token())).createAndStore();
        }
    }

    private void checkForInsecureEncoderInstantiations(ShallowEntity rootEntity, JavaImportSensitiveTypeResolver typeResolver) throws CheckException {
        for (JavaMethodCallMatcher.MethodCall constructorCall : INSECURE_ENCODER_CONSTRUCTOR_MATCHER.find(rootEntity, this.context.getTypeResolution(this.getCodeViewOption()), typeResolver)) {
            this.buildFinding("Use secure `PasswordEncoder` implementation", this.buildLocation().forToken(constructorCall.token())).createAndStore();
        }
    }
}

