/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.JavaExpressionTypeExtractor;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.MethodCallMatchers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

@Check(id="java:S5845", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION}, target={ECheckTarget.TEST_CODE})
public class IncompatibleTypesInAssertionCheck
extends CheckImplementationBase {
    private static final MethodCallMatchers ASSERTION_MATCHERS = MethodCallMatchers.combine((JavaMethodCallMatcher[])new JavaMethodCallMatcher[]{JavaMethodCallMatcher.create().onTypes(EJavaTestFramework.ASSERT_J.getAssertionTypes()).withTargetMethodNames(new String[]{"assertThat", "assertThatObject"}).withParameterCount(1).withTag((Object)EJavaTestFramework.ASSERT_J), JavaMethodCallMatcher.create().onTypes(EJavaTestFramework.JUNIT_4.getAssertionTypes()).withTargetMethodNames(new String[]{"assertNotNull", "assertNull", "assertEquals", "assertNotEquals"}).withParameterMinCount(1).withTag((Object)EJavaTestFramework.JUNIT_4), JavaMethodCallMatcher.create().onTypes(EJavaTestFramework.JUNIT_5.getAssertionTypes()).withTargetMethodNames(new String[]{"assertNotNull", "assertNull", "assertEquals", "assertNotEquals"}).withParameterMinCount(1).withTag((Object)EJavaTestFramework.JUNIT_5)});
    private static final String INCOMPATIBLE_TYPES_FINDINGS_MESSAGE = "Change the assertion arguments to not compare dissimilar types";
    private static final String INCOMPATIBLE_PRIMITIVE_FINDING_MESSAGE = "Change the assertion arguments to not compare a primitive value with null";
    private static final Set<String> JUNIT4_NULL_ASSERTIONS = Set.of("assertNotNull", "assertNull");
    private static final Set<String> ASSERTJ_CALLS = Set.of("isNotEqualTo", "isNull", "isNotNull", "isEqualTo", "isSameAs", "isNotSameAs");
    private static final Set<String> ASSERTJ_NULL_ASSERTIONS = Set.of("isNull", "isNotNull");
    private static final Set<String> ASSERTJ_INSTANCE_ASSERTIONS = Set.of("isEqualTo", "isNotEqualTo", "isSameAs", "isNotSameAs");
    private static final List<BiFunction<JavaExpressionTypeExtractor.InferTypeResult, JavaExpressionTypeExtractor.InferTypeResult, Boolean>> INCOMPATIBLE_TYPES_CONDITIONS = List.of((a, b) -> !a.canBeNull() && b.isNull(), (a, b) -> a.isLiteral() && b.isArray(), (a, b) -> a.isPrimitive() && b.isArray(), (a, b) -> a.isString() && b.isArray(), (a, b) -> a.isString() && b.isPrimitive(), (a, b) -> a.isArray() && !a.isPrimitiveArray() && b.isPrimitiveArray(), (a, b) -> a.isArray() && (b.isPrimitive() || b.isLiteral()));

    public void execute() throws CheckException {
        if (LanguageFeatureParser.JAVA.getTestFrameworkImports((List)this.getRootChildren()).isEmpty()) {
            return;
        }
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        ITypeResolution typeResolution = this.context.getTypeResolution(this.getCodeViewOption());
        block5: for (JavaMethodCallMatcher.MethodCall assertThatCall : ASSERTION_MATCHERS.find(this.context, typeResolver)) {
            EJavaTestFramework framework = (EJavaTestFramework)assertThatCall.tag();
            switch (framework) {
                case ASSERT_J: {
                    this.checkAssertJCall(assertThatCall, typeResolution, typeResolver);
                    continue block5;
                }
                case JUNIT_4: {
                    this.checkJunitAssertion(assertThatCall.methodName(), assertThatCall.entity(), IncompatibleTypesInAssertionCheck.filterJunit4Parameters(assertThatCall), typeResolution, typeResolver);
                    continue block5;
                }
                case JUNIT_5: {
                    this.checkJunitAssertion(assertThatCall.methodName(), assertThatCall.entity(), assertThatCall.parameters(), typeResolution, typeResolver);
                    continue block5;
                }
            }
            CCSMAssert.fail((String)("Unexpected test framework: " + String.valueOf(framework)));
        }
    }

    private static List<List<IToken>> filterJunit4Parameters(JavaMethodCallMatcher.MethodCall assertThatCall) {
        if (assertThatCall.parameters().size() > 2 || JUNIT4_NULL_ASSERTIONS.contains(assertThatCall.methodName()) && assertThatCall.parameters().size() > 1) {
            return CollectionUtils.remove(new ArrayList(assertThatCall.parameters()), (int)0);
        }
        return assertThatCall.parameters();
    }

    private void checkAssertJCall(JavaMethodCallMatcher.MethodCall assertThatCall, ITypeResolution typeResolution, JavaImportSensitiveTypeResolver typeResolver) {
        List chainedCalls = assertThatCall.findChainedCalls();
        if (chainedCalls.isEmpty()) {
            return;
        }
        int[] comparisonIndices = IntStream.range(0, chainedCalls.size()).filter(i -> ASSERTJ_CALLS.contains(((JavaMethodCallMatcher.ChainedCall)chainedCalls.get(i)).methodName())).toArray();
        if (comparisonIndices.length == 0) {
            return;
        }
        Optional typeInAssertThat = JavaExpressionTypeExtractor.inferExpressionResultType((ShallowEntity)assertThatCall.entity(), (List)((List)assertThatCall.parameters().getFirst()), (ITypeResolution)typeResolution, (JavaImportSensitiveTypeResolver)typeResolver);
        if (typeInAssertThat.isEmpty()) {
            return;
        }
        for (int chainMethodIndex : comparisonIndices) {
            if (IncompatibleTypesInAssertionCheck.previousChainsMayHaveChangedType(chainedCalls, chainMethodIndex)) {
                return;
            }
            JavaMethodCallMatcher.ChainedCall chainedCall = (JavaMethodCallMatcher.ChainedCall)chainedCalls.get(chainMethodIndex);
            Optional typeInChainedCall = JavaExpressionTypeExtractor.inferExpressionResultType((ShallowEntity)assertThatCall.entity(), (List)chainedCall.parameters(), (ITypeResolution)typeResolution, (JavaImportSensitiveTypeResolver)typeResolver);
            if (typeInChainedCall.isEmpty() && !chainedCall.parameters().isEmpty()) continue;
            Optional<String> findingsMessage = IncompatibleTypesInAssertionCheck.isIncompatibleComparison(chainedCall.methodName(), (JavaExpressionTypeExtractor.InferTypeResult)typeInAssertThat.get(), typeInChainedCall.orElse(null));
            if (findingsMessage.isPresent()) {
                this.buildFinding(findingsMessage.get(), this.buildLocation().forToken(chainedCall.callToken())).createAndStore();
                return;
            }
            if (!typeInChainedCall.isPresent() || !IncompatibleTypesInAssertionCheck.typesAreIncompatible((JavaExpressionTypeExtractor.InferTypeResult)typeInAssertThat.get(), (JavaExpressionTypeExtractor.InferTypeResult)typeInChainedCall.get(), true)) continue;
            this.buildFinding(INCOMPATIBLE_TYPES_FINDINGS_MESSAGE, this.buildLocation().forToken(chainedCall.callToken())).createAndStore();
        }
    }

    private void checkJunitAssertion(String assertMethod, ShallowEntity statement, List<List<IToken>> cleanedParameters, ITypeResolution typeResolution, JavaImportSensitiveTypeResolver typeResolver) {
        if (cleanedParameters.isEmpty()) {
            return;
        }
        switch (assertMethod) {
            case "assertNull": 
            case "assertNotNull": {
                this.checkNullAssertion(statement, cleanedParameters.getFirst(), typeResolution, typeResolver);
                return;
            }
            case "assertEquals": 
            case "assertNotEquals": {
                this.checkJUnitEqualsAssertion(statement, cleanedParameters, typeResolution, typeResolver);
            }
        }
    }

    private void checkJUnitEqualsAssertion(ShallowEntity statement, List<List<IToken>> methodParameters, ITypeResolution typeResolution, JavaImportSensitiveTypeResolver typeResolver) {
        if (methodParameters.size() < 2) {
            return;
        }
        Optional firstType = JavaExpressionTypeExtractor.inferExpressionResultType((ShallowEntity)statement, methodParameters.get(0), (ITypeResolution)typeResolution, (JavaImportSensitiveTypeResolver)typeResolver);
        if (firstType.isEmpty()) {
            return;
        }
        Optional secondType = JavaExpressionTypeExtractor.inferExpressionResultType((ShallowEntity)statement, methodParameters.get(1), (ITypeResolution)typeResolution, (JavaImportSensitiveTypeResolver)typeResolver);
        if (secondType.isEmpty()) {
            return;
        }
        if (IncompatibleTypesInAssertionCheck.typesAreIncompatible((JavaExpressionTypeExtractor.InferTypeResult)firstType.get(), (JavaExpressionTypeExtractor.InferTypeResult)secondType.get(), false)) {
            this.buildFinding(INCOMPATIBLE_TYPES_FINDINGS_MESSAGE, this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private void checkNullAssertion(ShallowEntity statement, List<IToken> parameters, ITypeResolution typeResolution, JavaImportSensitiveTypeResolver typeResolver) {
        Optional parameterType = JavaExpressionTypeExtractor.inferExpressionResultType((ShallowEntity)statement, parameters, (ITypeResolution)typeResolution, (JavaImportSensitiveTypeResolver)typeResolver);
        if (parameterType.isPresent() && !((JavaExpressionTypeExtractor.InferTypeResult)parameterType.get()).canBeNull()) {
            String message = INCOMPATIBLE_TYPES_FINDINGS_MESSAGE;
            if (((JavaExpressionTypeExtractor.InferTypeResult)parameterType.get()).isPrimitive()) {
                message = INCOMPATIBLE_PRIMITIVE_FINDING_MESSAGE;
            }
            this.buildFinding(message, this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private static boolean previousChainsMayHaveChangedType(List<JavaMethodCallMatcher.ChainedCall> chainedCalls, int chainMethodIndex) {
        for (int i = 0; i < chainMethodIndex; ++i) {
            if (EJavaTestFramework.ASSERT_J_VALUE_NEUTRAL_METHODS.contains(chainedCalls.get(i).methodName()) || chainedCalls.get(i).parameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static Optional<String> isIncompatibleComparison(String assertionMethod, JavaExpressionTypeExtractor.InferTypeResult assertThatType, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable JavaExpressionTypeExtractor.InferTypeResult assertionClauseType) {
        boolean isNullAssertion;
        boolean bl = isNullAssertion = ASSERTJ_NULL_ASSERTIONS.contains(assertionMethod) || ASSERTJ_INSTANCE_ASSERTIONS.contains(assertionMethod) && assertionClauseType != null && assertionClauseType.isNull();
        if (!assertThatType.canBeNull() && (isNullAssertion || assertionClauseType != null && assertionClauseType.isNull())) {
            return Optional.of(INCOMPATIBLE_PRIMITIVE_FINDING_MESSAGE);
        }
        if (assertionClauseType == null) {
            return Optional.empty();
        }
        if (assertThatType.getKnownBaseType().equals((Object)assertionClauseType.getKnownBaseType())) {
            return Optional.empty();
        }
        if (!isNullAssertion && IncompatibleTypesInAssertionCheck.checkConditionBothWays(assertThatType, assertionClauseType, (a, b) -> a.isPrimitive() && b.isString())) {
            return Optional.of(INCOMPATIBLE_TYPES_FINDINGS_MESSAGE);
        }
        return Optional.empty();
    }

    private static boolean typesAreIncompatible(JavaExpressionTypeExtractor.InferTypeResult assertThatType, JavaExpressionTypeExtractor.InferTypeResult otherType, boolean isAssertJ) {
        for (BiFunction<JavaExpressionTypeExtractor.InferTypeResult, JavaExpressionTypeExtractor.InferTypeResult, Boolean> condition : INCOMPATIBLE_TYPES_CONDITIONS) {
            if (!IncompatibleTypesInAssertionCheck.checkConditionBothWays(assertThatType, otherType, condition)) continue;
            return true;
        }
        if (assertThatType.isPrimitiveArray() && otherType.isPrimitiveArray() && !assertThatType.inferredType().equals(otherType.inferredType())) {
            return true;
        }
        if (isAssertJ && assertThatType.isString() && otherType.isDate()) {
            return true;
        }
        return !isAssertJ && IncompatibleTypesInAssertionCheck.checkConditionBothWays(assertThatType, otherType, (a, b) -> a.isString() && b.isDate());
    }

    private static boolean checkConditionBothWays(JavaExpressionTypeExtractor.InferTypeResult a, JavaExpressionTypeExtractor.InferTypeResult b, BiFunction<JavaExpressionTypeExtractor.InferTypeResult, JavaExpressionTypeExtractor.InferTypeResult, Boolean> condition) {
        return condition.apply(a, b) != false || condition.apply(b, a) != false;
    }
}

