/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-java-avoid-c-style-array-declaration", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JavaAvoidCStyleArrayDeclarationCheck
extends CheckImplementationBase {
    private static final ITokenMatcher ALLOWED_PREDECESSORS = LanguageFeatureParser.JAVA.typeTokenMatcher().except(new ITokenMatcher[]{ETokenType.VOID}).or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RBRACK, ETokenType.COMMA})});

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            if (selectedEntity.getType() == EShallowEntityType.STATEMENT && !"local variable".equals(selectedEntity.getSubtype()) || !TokenStreamUtils.containsSequence((List)selectedEntity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LBRACK, ETokenType.RBRACK})) continue;
            this.processEntity(selectedEntity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        int successorIndex;
        UnmodifiableList tokens = entity.includedTokens();
        int arrayNameIndex = TokenStreamUtils.firstTokenOfTypeSequence((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LBRACK, ETokenType.RBRACK});
        int predecessorIndex = arrayNameIndex - 1;
        if (predecessorIndex >= 0 && !ALLOWED_PREDECESSORS.matches((IToken)tokens.get(predecessorIndex))) {
            return;
        }
        int bracketStartIndex = arrayNameIndex + 1;
        if (!TokenStreamUtils.hasTokenTypeSequence((List)tokens, (int)bracketStartIndex, (ETokenType[])new ETokenType[]{ETokenType.LBRACK, ETokenType.RBRACK})) {
            return;
        }
        int dimensionality = 1;
        while (bracketStartIndex + dimensionality * 2 + 1 < tokens.size() && ((IToken)tokens.get(bracketStartIndex + dimensionality * 2)).getType() == ETokenType.LBRACK && ((IToken)tokens.get(bracketStartIndex + dimensionality * 2 + 1)).getType() == ETokenType.RBRACK) {
            ++dimensionality;
        }
        EnumSet<ETokenType> allowedSuccessors = EnumSet.of(ETokenType.EQ, ETokenType.SEMICOLON, ETokenType.COMMA);
        if (!allowedSuccessors.contains(((IToken)tokens.get(successorIndex = arrayNameIndex + dimensionality * 2 + 1)).getType())) {
            return;
        }
        this.buildFinding("Avoid using C-style array declarations in Java", this.buildLocation().forEntity(entity)).createAndStore();
    }
}

