/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.clike.CLikeFieldUsageCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.filter.JavaAnnotatedEntityFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;

@Check(id="cqse-java-field-could-be-final", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class JavaFieldCouldBeFinalCheck
extends CLikeFieldUsageCheckBase {
    private static final String CHECK_OPTION_DESCRIPTION_FIELDS = "List of Java field annotations to exclude class fields from being reported as needing to be declared final";
    private static final String CHECK_OPTION_DESCRIPTION_CLASSES = "List of Java class annotations to exclude class fields from being reported as needing to be declared final";
    private JavaAnnotatedEntityFilter annotatedFieldFilter;
    private JavaAnnotatedEntityFilter annotatedClassFilter;
    @CheckOption(name="Java annotations for non-final fields", description="List of Java field annotations to exclude class fields from being reported as needing to be declared final")
    private Set<String> fieldAnnotations = CollectionUtils.asHashSet((Object[])new String[]{"Inject", "Autowired", "SpringBean", "EJB", "Mock", "Spy", "InjectMocks", "Builder.Default", "Setter"});
    @CheckOption(name="Java class annotations for non-final fields", description="List of Java class annotations to exclude class fields from being reported as needing to be declared final")
    private Set<String> classAnnotations = CollectionUtils.asHashSet((Object[])new String[]{"Setter", "Data", "Value"});

    public JavaFieldCouldBeFinalCheck() {
        super((CLikeLanguageFeatureParserBase)LanguageFeatureParser.JAVA);
    }

    public void initialize() throws CheckException {
        super.initialize();
        this.annotatedFieldFilter = new JavaAnnotatedEntityFilter();
        this.annotatedFieldFilter.addAnnotations(this.fieldAnnotations);
        this.annotatedClassFilter = new JavaAnnotatedEntityFilter();
        this.annotatedClassFilter.addAnnotations(this.classAnnotations);
    }

    private static Set<Pair<IToken, ShallowEntity>> filterFieldsWithAssignmentAtDeclaration(Set<Pair<IToken, ShallowEntity>> fields) {
        HashSet<Pair<IToken, ShallowEntity>> result = new HashSet<Pair<IToken, ShallowEntity>>();
        for (Pair<IToken, ShallowEntity> fieldTokenToParentEntity : fields) {
            ShallowEntity field = (ShallowEntity)fieldTokenToParentEntity.getSecond();
            if (!JavaFieldCouldBeFinalCheck.isFieldInitializedAtDeclaration(field)) continue;
            result.add(fieldTokenToParentEntity);
        }
        return result;
    }

    @Override
    protected boolean isFiltered(ShallowEntity field) {
        return this.annotatedFieldFilter.isFiltered(field) || this.annotatedClassFilter.isFiltered(field.getParent());
    }

    @Override
    protected String getFieldSelectionXPath() {
        return "//TYPE[subtype('class')]/ATTRIBUTE[subtype('attribute') and anymodifier('private') and not(anymodifier('static', 'final'))]";
    }

    @Override
    protected String getFindingMessage(String fieldName) {
        return "Field `" + fieldName + "` could be made final";
    }

    @Override
    protected String getProcessedEntitiesXPath() {
        return "descendant::METHOD[not(subtype('constructor') or subtype('static initializer'))] | descendant::STATEMENT";
    }

    @Override
    protected Set<Pair<IToken, ShallowEntity>> filterFieldsWithFinding(Set<Pair<IToken, ShallowEntity>> unanalyzedFieldTokenToParentEntity, Set<Pair<IToken, ShallowEntity>> failedAnalyzedFieldTokenToParentEntity) {
        Set<Pair<IToken, ShallowEntity>> filteredFailedFieldTokenToParentEntity = failedAnalyzedFieldTokenToParentEntity;
        if (unanalyzedFieldTokenToParentEntity.equals(failedAnalyzedFieldTokenToParentEntity)) {
            filteredFailedFieldTokenToParentEntity = JavaFieldCouldBeFinalCheck.filterFieldsWithAssignmentAtDeclaration(failedAnalyzedFieldTokenToParentEntity);
        }
        filteredFailedFieldTokenToParentEntity = JavaFieldCouldBeFinalCheck.filterFieldsWithoutAssignmentAtDeclaration(filteredFailedFieldTokenToParentEntity);
        return super.filterFieldsWithFinding(unanalyzedFieldTokenToParentEntity, filteredFailedFieldTokenToParentEntity);
    }

    @Override
    protected boolean analyzeTokens(List<IToken> tokens, String fieldName, EShallowEntityType entityType, boolean isShadowed) {
        return !this.languageFeatureParser.getVariableWritesFromTokens(tokens, fieldName, true, isShadowed).isEmpty();
    }

    private static boolean isFieldInitializedAtDeclaration(ShallowEntity field) {
        boolean isField = field.getType() == EShallowEntityType.ATTRIBUTE;
        boolean containsEqualSign = TokenStreamUtils.contains((List)field.ownStartTokens(), (ETokenType)ETokenType.EQ);
        return isField && containsEqualSign;
    }

    private static Set<Pair<IToken, ShallowEntity>> filterFieldsWithoutAssignmentAtDeclaration(Set<Pair<IToken, ShallowEntity>> failedAnalyzedFieldTokenToParentEntity) {
        return failedAnalyzedFieldTokenToParentEntity.stream().filter(tokenToParentEntity -> JavaFieldCouldBeFinalCheck.isFieldInitializedAtDeclaration((ShallowEntity)tokenToParentEntity.getSecond())).collect(Collectors.toSet());
    }
}

