/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-java-lang-import", languages={ELanguage.JAVA, ELanguage.XTEND}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JavaLangImportCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List topLevelEntities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        for (ShallowEntity topLevelEntity : topLevelEntities) {
            if (topLevelEntity.getType() != EShallowEntityType.META || !"import".equals(topLevelEntity.getSubtype())) continue;
            this.processEntity(topLevelEntity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (entity.getName() == null) {
            return;
        }
        if (StringUtils.removeLastPart((String)entity.getName(), (char)'.').equals("java.lang")) {
            this.buildFinding("Importing types from `java.lang` is unnecessary", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

