/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

public class JavaSuperclassHierarchyExtractorPhase
implements IGlobalExtractionPhase<SuperclassHierarchyValue, SuperclassHierarchyInfo> {
    private static final TokenPattern EXTENDS_CLASS = LanguageFeatureParser.JAVA.classExtendsPattern().sequence(new Object[]{ETokenType.IDENTIFIER, TokenPattern.of().repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER})}).group(0);
    private JavaImportSensitiveTypeResolver typeResolver;

    public List<SuperclassHierarchyValue> extract(ITokenElementContext fileContext) throws CheckException {
        this.typeResolver = new JavaImportSensitiveTypeResolver(fileContext.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED));
        return this.extractLevel(fileContext, (List<ShallowEntity>)fileContext.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED).getChildren()).toList();
    }

    private @NonNull Stream<SuperclassHierarchyValue> extractLevel(ITokenElementContext fileContext, List<ShallowEntity> children) {
        return Stream.concat(children.stream().flatMap(entity -> this.handleType(fileContext, (ShallowEntity)entity).stream()), children.stream().flatMap(entity -> this.extractLevel(fileContext, (List<ShallowEntity>)entity.getChildren())));
    }

    private Optional<SuperclassHierarchyValue> handleType(ITokenElementContext fileContext, ShallowEntity entity) {
        if (EShallowEntityType.TYPE != entity.getType()) {
            return Optional.empty();
        }
        Optional<String> optionalSuperClass = Optional.ofNullable(EXTENDS_CLASS.findFirstMatch((List)entity.ownStartTokens())).map(match -> match.groupString(0));
        return optionalSuperClass.map(superclass -> {
            String fqn = LanguageFeatureParser.JAVA.resolveFullyQualifiedTypeName(entity);
            return this.createValue(fileContext.getUniformPath(), fqn, new SuperclassHierarchyInfo(LanguageFeatureParser.JAVA.resolveFullyQualifiedTypeName(this.typeResolver, entity, superclass)));
        });
    }

    public SuperclassHierarchyValue createValue(String uniformPath, String className, SuperclassHierarchyInfo additionalInformation) {
        return new SuperclassHierarchyValue(uniformPath, className, additionalInformation);
    }

    public EnumSet<ELanguage> getLanguages() {
        return EnumSet.of(ELanguage.JAVA);
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.ABSTRACT_SYNTAX_TREE);
    }

    public boolean needsAccessByValue() {
        return true;
    }

    @IndexValueClass
    public record SuperclassHierarchyValue(String uniformPath, String className, SuperclassHierarchyInfo superclassHierarchyInfo) implements IExtractedValue<SuperclassHierarchyInfo>
    {
        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return this.className;
        }

        public SuperclassHierarchyInfo getAdditionalInformation() {
            return this.superclassHierarchyInfo;
        }
    }

    @IndexValueClass
    public record SuperclassHierarchyInfo(Set<String> possibleSuperclasses) implements Serializable
    {
    }
}

