/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-number-of-methods", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NumberOfMethodsCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum number of methods", description="The maximum number of methods that are allowed within a type.")
    private int maximumNumberOfMethods = 32;

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        List methods = NumberOfMethodsCheck.select((ShallowEntity)entity, (String)"child::METHOD[not(subtype('constructor'))]");
        if (methods.size() > this.maximumNumberOfMethods) {
            this.buildFinding("Too many methods (" + methods.size() + "/" + this.maximumNumberOfMethods + ")", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

