/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S4602", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SpringScanDefaultPackageCheck
extends CheckImplementationBase {
    private static final UnmodifiableMap<String, UnmodifiableSet<String>> ANNOTATIONS_AND_ATTRIBUTES = SpringScanDefaultPackageCheck.buildAnnotationsToAttributesMap();
    private boolean isInDefaultPackage = false;
    private Collection<String> importedTypes = Collections.emptySet();

    private static UnmodifiableMap<String, UnmodifiableSet<String>> buildAnnotationsToAttributesMap() {
        HashMap<String, UnmodifiableSet> annotationsToAttributes = new HashMap<String, UnmodifiableSet>();
        UnmodifiableSet basePackageAttribute = UnmodifiableSet.of(Set.of(LanguageFeatureParser.JAVA.getDefaultAnnotationParameterName(), "basePackages", "basePackageClasses"));
        annotationsToAttributes.put("ComponentScan", basePackageAttribute);
        annotationsToAttributes.put("org.springframework.context.annotation.ComponentScan", basePackageAttribute);
        annotationsToAttributes.put("ServletComponentScan", basePackageAttribute);
        annotationsToAttributes.put("org.springframework.boot.web.servlet.ServletComponentScan", basePackageAttribute);
        UnmodifiableSet scanBasePackageAttribute = UnmodifiableSet.of(Set.of("scanBasePackages", "scanBasePackageClasses"));
        annotationsToAttributes.put("SpringBootApplication", scanBasePackageAttribute);
        annotationsToAttributes.put("org.springframework.boot.autoconfigure.SpringBootApplication", scanBasePackageAttribute);
        return UnmodifiableMap.of(annotationsToAttributes);
    }

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        this.isInDefaultPackage = LanguageFeatureParser.JAVA.getPackageName(ast).isEmpty();
        this.importedTypes = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)ast, Collections.singleton(EShallowEntityType.META), Collections.singleton("import")).stream().map(ShallowEntity::getName).collect(Collectors.toSet());
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            List annotations = LanguageFeatureParser.JAVA.getAnnotations(type);
            this.processAnnotations(annotations);
        }
    }

    private void processAnnotations(Collection<ShallowEntity> annotations) {
        for (ShallowEntity annotation : annotations) {
            if (!LanguageFeatureParser.JAVA.isSpecificAnnotation(annotation, (Set)ANNOTATIONS_AND_ATTRIBUTES.keySet())) continue;
            this.processSingleAnnotation(annotation);
        }
    }

    private void processSingleAnnotation(ShallowEntity annotation) {
        String annotationName = annotation.getName();
        if (!LanguageFeatureParser.JAVA.annotationHasParameters(annotation)) {
            if (this.isInDefaultPackage) {
                this.buildFinding("Remove the annotation `@%s` or move the annotated class out of the default package".formatted(MarkupUtils.escapeMarkdownRelevantSymbols((String)annotationName)), this.buildLocation().forEntity(annotation)).createAndStore();
            }
        } else {
            Set relevantParameters = (Set)ANNOTATIONS_AND_ATTRIBUTES.get((Object)annotationName);
            if (relevantParameters != null) {
                this.processSingleAnnotationWithParameters(annotation, relevantParameters);
            }
        }
    }

    private void processSingleAnnotationWithParameters(ShallowEntity annotation, Set<String> relevantParameters) {
        List paramTokens = LanguageFeatureParser.JAVA.getAnnotationParameterTokens(annotation);
        if (paramTokens.isEmpty()) {
            return;
        }
        Map parameters = LanguageFeatureParser.JAVA.extractAnnotationParameters(paramTokens, relevantParameters);
        for (List values : parameters.values()) {
            values.stream().filter(JavaLanguageFeatureParser.ParameterValue::isEmptyString).forEach(v -> this.buildFinding("Define packages to scan. Don't rely on the default package", this.buildLocation().forTokens(v.getTokens())).createAndStore());
            values.stream().filter(this::isClassReferenceInDefaultPackage).forEach(v -> this.buildFinding("Remove the annotation `@%s` or move the `%s` class out of the default package".formatted(MarkupUtils.escapeMarkdownRelevantSymbols((String)annotation.getName()), MarkupUtils.escapeMarkdownRelevantSymbols((String)v.simpleClassName())), this.buildLocation().forTokens(v.getTokens())).createAndStore());
        }
    }

    private boolean isImportedClass(JavaLanguageFeatureParser.ParameterValue parameterValue) {
        String nameWithoutClassPostfix = StringUtils.stripSuffix((String)parameterValue.getValue(), (String)LanguageFeatureParser.JAVA.getClassSuffix());
        return this.importedTypes.stream().anyMatch(importedClass -> importedClass.endsWith(nameWithoutClassPostfix));
    }

    private boolean isClassReferenceInDefaultPackage(JavaLanguageFeatureParser.ParameterValue parameterValue) {
        if (!parameterValue.isClassReference() || !this.isInDefaultPackage) {
            return false;
        }
        if (this.isImportedClass(parameterValue)) {
            return false;
        }
        return !parameterValue.isQualifiedClassReference();
    }
}

