/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Check(id="cqse-switch-case-block-length", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SwitchCaseBlockLengthCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum case block length", description="The maximum allowed number of statements in a case block.")
    private int maximumCaseBlockLength = 10;
    private static final Set<String> TARGET_SUBTYPES = Set.of("switch", "switch expression");

    public void execute() throws CheckException {
        List targetEntities = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.allOf(EShallowEntityType.class), TARGET_SUBTYPES);
        for (ShallowEntity entity : targetEntities) {
            if (entity.getChildren().size() <= this.maximumCaseBlockLength) continue;
            this.processEntity(entity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        HashSet<ShallowEntity> tooLongCases = new HashSet<ShallowEntity>();
        ShallowEntity lastCaseEntity = null;
        int statementCounter = 0;
        for (ShallowEntity child : entity.getChildren()) {
            if (child.getSubtype().equals("case") || child.getSubtype().equals("default")) {
                statementCounter = 0;
                lastCaseEntity = child;
            } else {
                ++statementCounter;
            }
            if (statementCounter <= this.maximumCaseBlockLength || lastCaseEntity == null) continue;
            tooLongCases.add(lastCaseEntity);
        }
        for (ShallowEntity tooLongCase : tooLongCases) {
            this.buildFinding("Case block should not exceed " + this.maximumCaseBlockLength + " statements", this.buildLocation().forEntityFirstLine(tooLongCase)).createAndStore();
        }
    }
}

