/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.java.ImportCheckBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class UnwantedImportCheckBase
extends ImportCheckBase {
    private static final EnumSet<ETokenType> IMPORTED_ENTITY_TOKEN_TYPES = EnumSet.of(ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.MULT);
    private final List<Pattern> unwantedImportPatterns = new ArrayList<Pattern>();

    public void initialize() throws CheckException {
        super.initialize();
        for (String unwantedImport : this.getUnwantedImports()) {
            this.unwantedImportPatterns.add(Pattern.compile(unwantedImport));
        }
    }

    public abstract Set<String> getUnwantedImports();

    public abstract String getFindingMessage();

    @Override
    protected void processEntity(ShallowEntity entity) throws CheckException {
        String importedEntity = TokenStreamTextUtils.concatTokenTexts(UnwantedImportCheckBase.getImportRelevantTokens(entity));
        for (Pattern pattern : this.unwantedImportPatterns) {
            if (!pattern.matcher(importedEntity).matches()) continue;
            this.buildFinding(this.getFindingMessage() + ": `" + importedEntity + "`", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private static List<IToken> getImportRelevantTokens(ShallowEntity entity) {
        return CollectionUtils.filter((Collection)entity.includedTokens(), token -> IMPORTED_ENTITY_TOKEN_TYPES.contains(token.getType()));
    }
}

